/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VsdmCheckDigitVersionTest {
    VsdmCheckDigitVersionTest() {
    }

    @Test
    void shouldReturnCorrectVersionForByte() {
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V1, (Object)VsdmCheckDigitVersion.fromData((byte[])new byte[]{1}));
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V1, (Object)VsdmCheckDigitVersion.fromData((byte[])new byte[]{-128}));
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V2, (Object)VsdmCheckDigitVersion.fromData((byte[])new byte[]{-127}));
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V2, (Object)VsdmCheckDigitVersion.fromData((byte[])new byte[]{-38}));
    }

    @Test
    void shouldReturnCorrectVersionForBase64() {
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V1, (Object)VsdmCheckDigitVersion.fromData((String)"WTc4NTcyODA3MTE2ODU0NDA4MzdVQzEpQdKViiyA4SGBIjkJuPVMWhLD6OBwggI="));
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V2, (Object)VsdmCheckDigitVersion.fromData((String)"wbGE920hMl4Hjm4oNc624ocDLdqzh8S6UA5LB7Q/iTYYT7JxUumHh6n+T2vdyd0="));
    }

    @Test
    void shouldThrowException() {
        byte[] dataNull = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> VsdmCheckDigitVersion.fromData((byte[])dataNull));
        byte[] dataEmpty = new byte[]{};
        Assertions.assertThrows(IllegalArgumentException.class, () -> VsdmCheckDigitVersion.fromData((byte[])dataEmpty));
    }
}

