/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm;

import de.gematik.bbriccs.vsdm.VsdmCheckDigit;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitFactory;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV1;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV2;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.VsdmUtils;
import de.gematik.bbriccs.vsdm.types.VsdmKey;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import de.gematik.bbriccs.vsdm.types.VsdmPatient;
import de.gematik.bbriccs.vsdm.types.VsdmUpdateReason;
import de.gematik.bbriccs.vsdm.types.VsdmVendorIdentifier;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class VsdmCheckDigitTest {
    private static final byte[] KEY = new byte[32];
    private static final VsdmKey KEY_V1;
    private static final VsdmKey KEY_V2;

    VsdmCheckDigitTest() {
    }

    @Test
    void shouldSignDheckDigitV1() {
        VsdmCheckDigitV1 checkDigit = VsdmCheckDigitFactory.createV1((String)"X123456789", (char)'S');
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertDoesNotThrow(() -> checkDigit.sign(KEY_V1)), () -> Assertions.assertEquals((Object)"X123456789", (Object)checkDigit.getPatient().getKvnr()), () -> Assertions.assertEquals((Object)checkDigit.getIdentifier(), (Object)VsdmVendorIdentifier.from((char)'S', (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1))});
    }

    @Test
    void shouldParseCheckDigitV1() {
        VsdmCheckDigitV1 checkDigit = VsdmCheckDigitFactory.createV1((String)"X123456789", (char)'S');
        String base64 = checkDigit.sign(KEY_V1);
        Assertions.assertDoesNotThrow(() -> VsdmCheckDigit.parse((String)base64));
        VsdmCheckDigitV1 checkDigit2 = VsdmCheckDigit.parse((String)base64);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)checkDigit.getPatient().getKvnr(), (Object)checkDigit2.getPatient().getKvnr(), (String)"Kvnr is not the same"), () -> Assertions.assertEquals((Object)checkDigit.getIdentifier(), (Object)checkDigit2.getIdentifier(), (String)"Identifier is not the same"), () -> Assertions.assertEquals((int)0, (int)checkDigit2.getIatTimestamp().compareIatTimestampWith(checkDigit.getIatTimestamp().getTimestamp()), (String)"IatTime is not the same")});
    }

    @Test
    void shouldEncryptCheckDigitV2() {
        Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        VsdmPatient patient = new VsdmPatient(VsdmKvnr.from((String)"X123456789"), true, LocalDate.now(), "ExampleStreet");
        VsdmCheckDigitV2 checkDigit = VsdmCheckDigitFactory.createV2((VsdmPatient)patient, (char)'A').setIatTimestamp(now);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertDoesNotThrow(() -> checkDigit.encrypt(KEY_V2)), () -> Assertions.assertEquals((Object)"X123456789", (Object)checkDigit.getPatient().getKvnr()), () -> Assertions.assertEquals((Object)now, (Object)checkDigit.getIatTimestamp().getTimestamp())});
        VsdmCheckDigitV2 checkDigit2 = VsdmCheckDigit.decrypt((VsdmKey)KEY_V2, (String)checkDigit.encrypt(KEY_V2));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"X123456789", (Object)checkDigit2.getPatient().getKvnr()), () -> Assertions.assertEquals((int)0, (int)checkDigit2.getIatTimestamp().compareIatTimestampWith(now))});
    }

    @Test
    void shouldCreate() {
        Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS);
        VsdmPatient patient = new VsdmPatient(VsdmKvnr.from((String)"X123456789"), false, LocalDate.now(), "ExampleStreet");
        VsdmCheckDigitV2 checkDigit = VsdmCheckDigitFactory.createV2((VsdmPatient)patient, (char)'A').setIatTimestamp(now);
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertDoesNotThrow(() -> checkDigit.encrypt(KEY_V2)), () -> Assertions.assertEquals((Object)"X123456789", (Object)checkDigit.getPatient().getKvnr()), () -> Assertions.assertEquals((Object)now, (Object)checkDigit.getIatTimestamp().getTimestamp())});
        VsdmCheckDigitV2 checkDigit2 = VsdmCheckDigit.decrypt((VsdmKey)KEY_V2, (String)checkDigit.encrypt(KEY_V2));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"X123456789", (Object)checkDigit2.getPatient().getKvnr()), () -> Assertions.assertEquals((int)0, (int)checkDigit2.getIatTimestamp().compareIatTimestampWith(now))});
    }

    @Test
    void shouldDecryptCheckDigitV2() {
        String base64V2 = "3gyWVfvt1Yncz80adEC997AOEMJAzBxElpKwgyPfL+mGjrG31Yo4AqT9vT168v0=";
        Assertions.assertDoesNotThrow(() -> VsdmCheckDigit.decrypt((VsdmKey)KEY_V2, (String)"3gyWVfvt1Yncz80adEC997AOEMJAzBxElpKwgyPfL+mGjrG31Yo4AqT9vT168v0="));
        VsdmCheckDigitV2 checkDigit = VsdmCheckDigit.decrypt((VsdmKey)KEY_V2, (String)"3gyWVfvt1Yncz80adEC997AOEMJAzBxElpKwgyPfL+mGjrG31Yo4AqT9vT168v0=");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"A123456789", (Object)checkDigit.getPatient().getKvnr(), (String)"Kvnr is not the same"), () -> Assertions.assertFalse((boolean)checkDigit.getPatient().isEgkRevoked(), (String)"EgkRevoked is not the same"), () -> Assertions.assertEquals((char)'X', (char)checkDigit.getIdentifier().identifier(), (String)"Identifier is not the same"), () -> Assertions.assertEquals((int)0, (int)checkDigit.getIatTimestamp().compareIatTimestampWith(checkDigit.getIatTimestamp().getTimestamp()), (String)"IatTime is not the same"), () -> Assertions.assertEquals((Object)LocalDateTime.parse("2025-01-12T21:35:12").toInstant(ZoneOffset.UTC), (Object)checkDigit.getIatTimestamp().getTimestamp(), (String)"IatTime is not the same")});
    }

    @Test
    void shouldParseValidChecksumV1() {
        Assertions.assertDoesNotThrow(() -> VsdmCheckDigit.parse((String)"WTc4NTcyODA3MTE2ODU0NDA4MzdVQzEpQdKViiyA4SGBIjkJuPVMWhLD6OBwggI="));
        VsdmCheckDigitV1 checksum = VsdmCheckDigit.parse((String)"WTc4NTcyODA3MTE2ODU0NDA4MzdVQzEpQdKViiyA4SGBIjkJuPVMWhLD6OBwggI=");
        Assertions.assertEquals((Object)"Y785728071", (Object)checksum.getPatient().getKvnr());
        Assertions.assertEquals((Object)VsdmCheckDigitVersion.V1, (Object)checksum.getVersion());
        Assertions.assertEquals((Object)VsdmVendorIdentifier.from((char)'C', (VsdmCheckDigitVersion)VsdmCheckDigitVersion.V1), (Object)checksum.getIdentifier());
        Assertions.assertEquals((Object)VsdmUpdateReason.UFS_UPDATE, (Object)checksum.getUpdateReason());
    }

    @Test
    void shouldThrowIllegalArgumentExceptionForInvalidChecksumLength() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> VsdmCheckDigit.parse((String)"WTc4NTcyODA3MTE2ODU0NDA4MzdVQzEpQdKViiyA4SGBIjm49UxaEsPo4HCCAg=="));
    }

    @Test
    void testCreateV2() {
        Assertions.assertDoesNotThrow(() -> VsdmCheckDigitFactory.createV2((String)"X123456789", (char)'A'));
    }

    @Test
    void testCheckDigitFactory() {
        try {
            Constructor constructor = VsdmCheckDigitFactory.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Assertions.assertThrows(InvocationTargetException.class, () -> {
                VsdmCheckDigitFactory cfr_ignored_0 = (VsdmCheckDigitFactory)constructor.newInstance(new Object[0]);
            });
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void testVsdmUtils() {
        try {
            Constructor constructor = VsdmUtils.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Assertions.assertThrows(InvocationTargetException.class, () -> {
                VsdmUtils cfr_ignored_0 = (VsdmUtils)constructor.newInstance(new Object[0]);
            });
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        VsdmCheckDigitTest.KEY[31] = 1;
        KEY_V1 = new VsdmKey(KEY, new VsdmKeyVersion('1', VsdmCheckDigitVersion.V1));
        KEY_V2 = new VsdmKey(KEY, new VsdmKeyVersion('2', VsdmCheckDigitVersion.V2));
    }
}

