/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import java.text.MessageFormat;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record VsdmVendorIdentifier(char identifier, VsdmCheckDigitVersion version) {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsdmVendorIdentifier.class);
    private static final int KEY_VERSION_INDEX_V1 = 21;
    private static final int KEY_VERSION_INDEX_V2 = 0;

    static void checkIdentifier(char identifier) {
        if (identifier < 'A' || identifier > 'Z') {
            log.warn(MessageFormat.format("Identifier ''{0}'' is not a capital letter", Character.valueOf(identifier)));
        }
    }

    public byte generate() {
        if (this.version == VsdmCheckDigitVersion.V1) {
            return (byte)this.identifier();
        }
        return (byte)(this.identifier() - 65 << 2);
    }

    public static VsdmVendorIdentifier parseV1(byte[] data) {
        try {
            char identifier = (char)data[21];
            VsdmVendorIdentifier.checkIdentifier(identifier);
            return new VsdmVendorIdentifier(identifier, VsdmCheckDigitVersion.V1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParsingException(data, 21);
        }
    }

    public static VsdmVendorIdentifier parseV2(byte[] data, VsdmKeyVersion keyVersion) {
        try {
            int bkD4 = (data[0] & 0xFF) - 128 - (keyVersion.keyVersion() - 48);
            char identifier = (char)((bkD4 >> 2) + 65);
            VsdmVendorIdentifier.checkIdentifier(identifier);
            return new VsdmVendorIdentifier(identifier, VsdmCheckDigitVersion.V2);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParsingException(data, 0);
        }
    }

    @Override
    public String toString() {
        return "" + this.identifier;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == VsdmVendorIdentifier.class) {
            VsdmVendorIdentifier otherIdentifier = (VsdmVendorIdentifier)o;
            return Objects.equals(Character.valueOf(this.identifier), Character.valueOf(otherIdentifier.identifier));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(Character.valueOf(this.identifier));
    }

    public static VsdmVendorIdentifier from(char identifier, VsdmCheckDigitVersion version) {
        return new VsdmVendorIdentifier(identifier, version);
    }
}

