/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.exceptions.ParsingUpdateResonException;
import java.text.MessageFormat;
import lombok.Generated;

public enum VsdmUpdateReason {
    UFS_UPDATE('U', "Update Flag Service (UFS) Anfrage"),
    VSD_UPDATE('V', "Versichertenstammdaten (VSD) Update"),
    CARD_MANAGEMENT_UPDATE('C', "Kartenmanagement (CMS) Update"),
    INVALID('I', "Invalid Reason (Test purpose)");

    private final String description;
    private final char identifier;

    private VsdmUpdateReason(char identifier, String description) {
        this.identifier = identifier;
        this.description = description;
    }

    public byte generate() {
        return (byte)this.identifier;
    }

    public String toString() {
        return MessageFormat.format("Identifier {0} Description: {1}", Character.valueOf(this.identifier), this.description);
    }

    public static VsdmUpdateReason fromChecksum(char value) throws ParsingUpdateResonException {
        return switch (value) {
            case 'U' -> UFS_UPDATE;
            case 'V' -> VSD_UPDATE;
            case 'C' -> CARD_MANAGEMENT_UPDATE;
            default -> throw new ParsingUpdateResonException(value);
        };
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public char getIdentifier() {
        return this.identifier;
    }
}

