/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class VsdmPatient {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
    private final VsdmKvnr kvnr;
    private final Boolean isEgkRevoked;
    private final Instant insuranceStartDate;
    private final String street;

    public VsdmPatient(VsdmKvnr kvnr) {
        this(kvnr, null, null, null);
    }

    public VsdmPatient(VsdmKvnr kvnr, Instant insuranceStartDate) {
        this(kvnr, false, insuranceStartDate.atOffset(ZoneOffset.UTC).toInstant(), null);
    }

    public String getKvnr() {
        return this.kvnr.kvnr();
    }

    public Optional<Boolean> isEgkRevoked() {
        return Optional.ofNullable(this.isEgkRevoked);
    }

    public Optional<Instant> getInsuranceStartDate() {
        return Optional.ofNullable(this.insuranceStartDate);
    }

    public Optional<String> getStreet() {
        return Optional.ofNullable(this.street);
    }

    public byte[] generateKvnr() {
        return this.kvnr.generate();
    }

    public byte[] generateField1() {
        byte[] hash = this.generateHash(this.insuranceStartDate, this.street);
        int s = this.isEgkRevoked != null && this.isEgkRevoked != false ? -128 : 0;
        hash[0] = (byte)(hash[0] | s);
        return hash;
    }

    public byte[] generateHash(Instant insuranceStartDate, String street) {
        Objects.requireNonNull(insuranceStartDate, "Insurance start date is required");
        Objects.requireNonNull(street, "Street is required");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String plain = MessageFormat.format("{0}{1}", DATE_FORMATTER.format(insuranceStartDate.atOffset(ZoneOffset.UTC)), street);
        byte[] hash = digest.digest(plain.getBytes(StandardCharsets.UTF_8));
        byte[] hash40 = Arrays.copyOfRange(hash, 0, 5);
        hash40[0] = (byte)(hash40[0] & 0x7F);
        return hash40;
    }

    public static VsdmPatient parse(byte[] data, VsdmCheckDigitVersion version) {
        VsdmKvnr kvnr = VsdmKvnr.parse(data, version);
        if (version == VsdmCheckDigitVersion.V1) {
            return new VsdmPatient(kvnr);
        }
        boolean isEgkRevoked = (data[0] & 0x80) != 0;
        return new VsdmPatient(kvnr, isEgkRevoked, null, null);
    }

    @Generated
    public VsdmPatient(VsdmKvnr kvnr, Boolean isEgkRevoked, Instant insuranceStartDate, String street) {
        this.kvnr = kvnr;
        this.isEgkRevoked = isEgkRevoked;
        this.insuranceStartDate = insuranceStartDate;
        this.street = street;
    }
}

