/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.VsdmUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record VsdmKvnr(String kvnr) {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsdmKvnr.class);

    public byte[] generate() {
        return this.kvnr.getBytes(StandardCharsets.US_ASCII);
    }

    public static VsdmKvnr parse(byte[] data, VsdmCheckDigitVersion version) {
        if (version == VsdmCheckDigitVersion.V1) {
            String kvnr = new String(VsdmUtils.copyByteArrayFrom(data, 0, 10), StandardCharsets.UTF_8);
            return new VsdmKvnr(kvnr);
        }
        byte[] byteValue = VsdmUtils.copyByteArrayFrom(data, 8, data.length);
        String kvnr = new String(byteValue, StandardCharsets.UTF_8);
        return new VsdmKvnr(kvnr);
    }

    @Override
    public String toString() {
        return this.kvnr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VsdmKvnr vsdmKvnr = (VsdmKvnr)o;
        return Objects.equals(this.kvnr, vsdmKvnr.kvnr);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.kvnr);
    }

    public static VsdmKvnr from(String kvnr) {
        return new VsdmKvnr(kvnr);
    }
}

