/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.exceptions.InvalidKeyLengthException;
import de.gematik.bbriccs.vsdm.types.VsdmKeyVersion;
import java.util.Arrays;
import java.util.Objects;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public record VsdmKey(byte[] key, VsdmKeyVersion keyVersion) {
    public VsdmKey {
        if (key.length != 32) {
            throw new InvalidKeyLengthException(key, 32);
        }
    }

    public KeyParameter getKeyForVersion1() {
        return new KeyParameter(this.key);
    }

    public SecretKeySpec getKeyForVersion2() {
        String info = "VSDM+ Version 2 AES/GCM";
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
        HKDFParameters params = new HKDFParameters(this.key, null, "VSDM+ Version 2 AES/GCM".getBytes());
        hkdf.init((DerivationParameters)params);
        byte[] aesKey = new byte[16];
        hkdf.generateBytes(aesKey, 0, aesKey.length);
        return new SecretKeySpec(aesKey, "AES");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VsdmKey vsdmKey = (VsdmKey)o;
        return Objects.deepEquals(this.key, vsdmKey.key) && Objects.equals(this.keyVersion, vsdmKey.keyVersion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.key), this.keyVersion);
    }

    @Override
    public String toString() {
        return "VsdmKey{key=" + Arrays.toString(this.key) + ", keyVersion=" + this.keyVersion + "}";
    }
}

