/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm.types;

import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.VsdmUtils;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsdmIssuedAtTimestamp {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsdmIssuedAtTimestamp.class);
    private static final Instant OFFSET_V2 = LocalDateTime.parse("2025-01-01T00:00:00").toInstant(ZoneOffset.UTC);
    private final Instant timestamp;
    private final VsdmCheckDigitVersion version;

    public VsdmIssuedAtTimestamp(Instant iatTimestamp, VsdmCheckDigitVersion version) {
        this.timestamp = iatTimestamp;
        this.version = version;
    }

    public VsdmIssuedAtTimestamp(VsdmCheckDigitVersion version) {
        this(LocalDateTime.now().toInstant(ZoneOffset.UTC), version);
    }

    public byte[] generate() {
        if (this.version == VsdmCheckDigitVersion.V1) {
            long timestampAsLong = this.getTimestamp().getEpochSecond();
            return ("" + timestampAsLong).getBytes(StandardCharsets.UTF_8);
        }
        long relativeTimestamp = this.timestamp.getEpochSecond() - OFFSET_V2.getEpochSecond();
        return VsdmUtils.long2ByteArray(relativeTimestamp >>= 3, 3);
    }

    public static VsdmIssuedAtTimestamp parse(byte[] data, VsdmCheckDigitVersion version) {
        if (version == VsdmCheckDigitVersion.V1) {
            Instant timestamp = Instant.ofEpochSecond(Long.parseLong(new String(VsdmUtils.copyByteArrayFrom(data, 10, 20), StandardCharsets.UTF_8)));
            return new VsdmIssuedAtTimestamp(timestamp.truncatedTo(ChronoUnit.SECONDS), version);
        }
        byte[] iat = VsdmUtils.copyByteArrayFrom(data, 5, 8);
        long relativeTime = ((iat[0] & 0xFF) << 16 | (iat[1] & 0xFF) << 8 | iat[2] & 0xFF) << 3;
        Instant timestamp = Instant.ofEpochSecond(relativeTime + OFFSET_V2.getEpochSecond());
        return new VsdmIssuedAtTimestamp(timestamp.truncatedTo(ChronoUnit.SECONDS), version);
    }

    public int compareIatTimestampWith(Instant referenceTime) {
        long iatTimeInSeconds = this.timestamp.getEpochSecond();
        long referenceTimeInSeconds = referenceTime.getEpochSecond();
        if (referenceTimeInSeconds - 1200L + 30L > iatTimeInSeconds) {
            return -1;
        }
        if (referenceTimeInSeconds + 30L < iatTimeInSeconds) {
            return 1;
        }
        return 0;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public VsdmCheckDigitVersion getVersion() {
        return this.version;
    }
}

