/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm;

import de.gematik.bbriccs.vsdm.exceptions.ParsingException;
import java.util.Arrays;

public class VsdmUtils {
    private VsdmUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] copyByteArrayFrom(byte[] data, int from, int to) throws ParsingException {
        if (data == null || data.length == 0) {
            throw new ParsingException();
        }
        if (to > data.length) {
            throw new ParsingException(data, from, to);
        }
        try {
            return Arrays.copyOfRange(data, from, to);
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new ParsingException(data, from, to);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            hexString.append(String.format("%02X ", b));
        }
        return hexString.toString();
    }

    public static byte[] long2ByteArray(long value, int nrOfBytes) {
        byte[] result = new byte[nrOfBytes];
        for (int i = 0; i < nrOfBytes && i < 8; ++i) {
            result[nrOfBytes - 1 - i] = (byte)(value >>> i * 8);
        }
        return result;
    }
}

