/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm;

import de.gematik.bbriccs.vsdm.VsdmCheckDigit;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV1;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV2;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.types.VsdmKvnr;
import de.gematik.bbriccs.vsdm.types.VsdmPatient;
import de.gematik.bbriccs.vsdm.types.VsdmVendorIdentifier;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class VsdmCheckDigitFactory {
    private VsdmCheckDigitFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static VsdmCheckDigitV1 createV1(String kvnr, char identifier) {
        VsdmPatient patient = new VsdmPatient(VsdmKvnr.from(kvnr));
        return new VsdmCheckDigit(patient, VsdmVendorIdentifier.from(identifier, VsdmCheckDigitVersion.V1));
    }

    public static VsdmCheckDigitV2 createV2(String kvnr, char identifier) {
        VsdmPatient patient = new VsdmPatient(VsdmKvnr.from(kvnr), false, Instant.now().minus(365L, ChronoUnit.DAYS), "ExampleStreet");
        return VsdmCheckDigitFactory.createV2(patient, identifier);
    }

    public static VsdmCheckDigitV2 createV2(VsdmPatient patient, char identifier) {
        return new VsdmCheckDigit(patient, VsdmVendorIdentifier.from(identifier, VsdmCheckDigitVersion.V2));
    }
}

