/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.vsdm;

import de.gematik.bbriccs.crypto.encryption.AesGcm;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV1;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitV2;
import de.gematik.bbriccs.vsdm.VsdmCheckDigitVersion;
import de.gematik.bbriccs.vsdm.VsdmUtils;
import de.gematik.bbriccs.vsdm.exceptions.ParsingVersionException;
import de.gematik.bbriccs.vsdm.types.VsdmIssuedAtTimestamp;
import de.gematik.bbriccs.vsdm.types.VsdmKey;
import de.gematik.bbriccs.vsdm.types.VsdmPatient;
import de.gematik.bbriccs.vsdm.types.VsdmUpdateReason;
import de.gematik.bbriccs.vsdm.types.VsdmVendorIdentifier;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.List;
import javax.crypto.SecretKey;
import lombok.Generated;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VsdmCheckDigit
implements VsdmCheckDigitV1,
VsdmCheckDigitV2 {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsdmCheckDigit.class);
    private final VsdmPatient patient;
    protected final VsdmVendorIdentifier identifier;
    private final VsdmCheckDigitVersion version;
    private VsdmIssuedAtTimestamp iatTimestamp;
    private VsdmUpdateReason updateReason = VsdmUpdateReason.UFS_UPDATE;

    protected VsdmCheckDigit(VsdmPatient patient, VsdmCheckDigitVersion version) {
        this(patient, null, version);
    }

    protected VsdmCheckDigit(VsdmPatient patient, VsdmVendorIdentifier identifier) {
        this(patient, identifier, identifier.version());
    }

    protected VsdmCheckDigit(VsdmPatient patient, VsdmVendorIdentifier identifier, VsdmCheckDigitVersion version) {
        this.patient = patient;
        this.identifier = identifier;
        this.version = version;
        this.iatTimestamp = new VsdmIssuedAtTimestamp(version);
    }

    private static byte[] base64Decode(String base64) {
        byte[] decodedBase64 = Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
        if (decodedBase64.length != 47) {
            throw new IllegalArgumentException("Invalid checksum length");
        }
        return decodedBase64;
    }

    @Override
    public String encrypt(VsdmKey key) {
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V2, this.version);
        byte[] plain = this.concatenate(List.of(this.patient.generateField1(), this.iatTimestamp.generate(), this.patient.generateKvnr()));
        AesGcm aesGcm = new AesGcm(12, 16);
        byte[] encrypt = aesGcm.encrypt((SecretKey)key.getKeyForVersion2(), plain);
        byte header = (byte)(128 + this.identifier.generate() + key.keyVersion().generate());
        return Base64.getEncoder().encodeToString(this.concatenate(List.of(Byte.valueOf(header), encrypt)));
    }

    public static VsdmCheckDigitV2 decrypt(VsdmKey key, String base64) {
        VsdmCheckDigitVersion version = VsdmCheckDigitVersion.fromData(base64);
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V2, version);
        byte[] decodedBase64 = VsdmCheckDigit.base64Decode(base64);
        byte[] ciphertext = VsdmUtils.copyByteArrayFrom(decodedBase64, 1, decodedBase64.length);
        AesGcm aesGcm = new AesGcm(12, 16);
        byte[] plain = aesGcm.decrypt((Key)key.getKeyForVersion2(), ciphertext);
        return new VsdmCheckDigit(VsdmPatient.parse(plain, version), VsdmVendorIdentifier.parseV2(decodedBase64, key.keyVersion())).setIatTimestamp(VsdmIssuedAtTimestamp.parse(plain, version));
    }

    public static VsdmCheckDigitV1 parse(String checksumAsBase64) {
        VsdmCheckDigitVersion version = VsdmCheckDigitVersion.fromData(checksumAsBase64);
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V1, version);
        byte[] decodedBase64 = VsdmCheckDigit.base64Decode(checksumAsBase64);
        VsdmPatient patient = VsdmPatient.parse(decodedBase64, version);
        VsdmIssuedAtTimestamp iatTimestamp = VsdmIssuedAtTimestamp.parse(decodedBase64, version);
        VsdmUpdateReason reason = VsdmUpdateReason.fromChecksum((char)decodedBase64[20]);
        VsdmVendorIdentifier identifier = VsdmVendorIdentifier.parseV1(decodedBase64);
        return new VsdmCheckDigit(patient, identifier, version).setIatTimestamp(iatTimestamp).setUpdateReason(reason);
    }

    @Override
    public String sign(VsdmKey key) {
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V1, this.version);
        HMac hMac = new HMac((Digest)new SHA256Digest());
        hMac.init((CipherParameters)key.getKeyForVersion1());
        byte[] data = this.concatenate(List.of(this.patient.generateKvnr(), this.iatTimestamp.generate(), Byte.valueOf(this.updateReason.generate()), Byte.valueOf(this.identifier.generate()), Byte.valueOf(key.keyVersion().generate())));
        hMac.update(data, 0, data.length);
        byte[] signature = new byte[hMac.getMacSize()];
        hMac.doFinal(signature, 0);
        byte[] checksum = new byte[data.length + 24];
        System.arraycopy(data, 0, checksum, 0, data.length);
        System.arraycopy(signature, 0, checksum, data.length, 24);
        return Base64.getEncoder().encodeToString(checksum);
    }

    @Override
    public VsdmUpdateReason getUpdateReason() {
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V1, this.version);
        return this.updateReason;
    }

    @Override
    public VsdmCheckDigit setIatTimestamp(Instant iatTimestamp) {
        return this.setIatTimestamp(new VsdmIssuedAtTimestamp(iatTimestamp.truncatedTo(ChronoUnit.SECONDS), this.version));
    }

    @Override
    public VsdmCheckDigit setIatTimestamp(VsdmIssuedAtTimestamp iatTimestamp) {
        this.iatTimestamp = iatTimestamp;
        return this;
    }

    @Override
    public VsdmCheckDigit setUpdateReason(VsdmUpdateReason reason) {
        VsdmCheckDigit.checkVsdmVersion(VsdmCheckDigitVersion.V1, this.version);
        this.updateReason = reason;
        return this;
    }

    private byte[] concatenate(List<Object> elements) {
        int totalLength = 0;
        for (Object element : elements) {
            if (element instanceof byte[]) {
                byte[] elementAsByteArray = (byte[])element;
                totalLength += elementAsByteArray.length;
                continue;
            }
            if (element instanceof Byte) {
                ++totalLength;
                continue;
            }
            throw new IllegalArgumentException("Unsupported element type");
        }
        byte[] result = new byte[totalLength];
        int currentPosition = 0;
        for (Object element : elements) {
            if (element instanceof byte[]) {
                byte[] byteArray = (byte[])element;
                System.arraycopy(byteArray, 0, result, currentPosition, byteArray.length);
                currentPosition += byteArray.length;
                continue;
            }
            if (!(element instanceof Byte)) continue;
            Byte asByte = (Byte)element;
            result[currentPosition] = asByte;
            ++currentPosition;
        }
        return result;
    }

    private static void checkVsdmVersion(VsdmCheckDigitVersion supportedVersion, VsdmCheckDigitVersion version) {
        if (supportedVersion != version) {
            throw new ParsingVersionException(supportedVersion, version);
        }
    }

    @Override
    @Generated
    public VsdmPatient getPatient() {
        return this.patient;
    }

    @Override
    @Generated
    public VsdmVendorIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @Generated
    public VsdmCheckDigitVersion getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public VsdmIssuedAtTimestamp getIatTimestamp() {
        return this.iatTimestamp;
    }
}

