/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau.testutils;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.rest.vau.VauVersion;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Date;
import lombok.NonNull;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class VauCertificateGenerator {
    public static X509Certificate generateRandomVauCertificate() {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", BC.getSecurityProvider());
        keyPairGenerator.initialize(new ECGenParameterSpec(VauVersion.V1.getCurve()));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return VauCertificateGenerator.generateX509Certificate(privateKey, publicKey);
    }

    public static X509Certificate generateX509Certificate(@NonNull PrivateKey privateKey, @NonNull PublicKey publicKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        Instant now = Instant.now();
        Date notBefore = Date.from(now);
        Date until = new Date(LocalDate.now().plusYears(100L).toEpochDay());
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withECDSA").setProvider(BC.getSecurityProvider()).build(privateKey);
        X500Name x500Name = new X500Name("CN=Common Name,O=Organization,L=City,ST=State");
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(now.toEpochMilli()), notBefore, until, x500Name, publicKey);
        return new JcaX509CertificateConverter().setProvider(BC.getSecurityProvider()).getCertificate(certificateBuilder.build(contentSigner));
    }
}

