/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.rest.vau.InnerHttp;
import de.gematik.bbriccs.rest.vau.RawHttpCodec;
import de.gematik.bbriccs.rest.vau.exceptions.VauException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InnerHttpTest {
    private RawHttpCodec innerHttp;

    InnerHttpTest() {
    }

    @BeforeEach
    void setup() {
        this.innerHttp = new InnerHttp();
    }

    @Test
    void shouldDecodeValidResponse() {
        String exampleInnerHttp = "MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pgo8VGFzayB4bWxucz0iaHR0cDovL2hsNy5vcmcvZmhpciI+PGlkIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PG1ldGE+PHByb2ZpbGUgdmFsdWU9Imh0dHBzOi8vZ2VtYXRpay5kZS9maGlyL1N0cnVjdHVyZURlZmluaXRpb24vRXJ4VGFza3wxLjEuMSIvPjwvbWV0YT48ZXh0ZW5zaW9uIHVybD0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvU3RydWN0dXJlRGVmaW5pdGlvbi9QcmVzY3JpcHRpb25UeXBlIj48dmFsdWVDb2Rpbmc+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvQ29kZVN5c3RlbS9GbG93dHlwZSIvPjxjb2RlIHZhbHVlPSIxNjAiLz48ZGlzcGxheSB2YWx1ZT0iTXVzdGVyIDE2IChBcG90aGVrZW5wZmxpY2h0aWdlIEFyem5laW1pdHRlbCkiLz48L3ZhbHVlQ29kaW5nPjwvZXh0ZW5zaW9uPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL1ByZXNjcmlwdGlvbklEIi8+PHZhbHVlIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PC9pZGVudGlmaWVyPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL0FjY2Vzc0NvZGUiLz48dmFsdWUgdmFsdWU9ImMxNTU3MzNiN2QxMzJlYWQyN2FmZmFmN2JiOTUwYWIxNzBhNWIxZWIwMzE3OWU2ZGFiYWQyYjk0ZThhM2M5M2UiLz48L2lkZW50aWZpZXI+PHN0YXR1cyB2YWx1ZT0iZHJhZnQiLz48aW50ZW50IHZhbHVlPSJvcmRlciIvPjxhdXRob3JlZE9uIHZhbHVlPSIyMDIyLTA1LTE4VDE4OjU2OjQ1LjQ2MiswMDowMCIvPjxsYXN0TW9kaWZpZWQgdmFsdWU9IjIwMjItMDUtMThUMTg6NTY6NDUuNDYyKzAwOjAwIi8+PHBlcmZvcm1lclR5cGU+PGNvZGluZz48c3lzdGVtIHZhbHVlPSJ1cm46aWV0ZjpyZmM6Mzk4NiIvPjxjb2RlIHZhbHVlPSJ1cm46b2lkOjEuMi4yNzYuMC43Ni40LjU0Ii8+PGRpc3BsYXkgdmFsdWU9IsOWZmZlbnRsaWNoZSBBcG90aGVrZSIvPjwvY29kaW5nPjx0ZXh0IHZhbHVlPSLDlmZmZW50bGljaGUgQXBvdGhla2UiLz48L3BlcmZvcm1lclR5cGU+PC9UYXNrPgo=";
        HttpBResponse response = this.innerHttp.decode("MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pgo8VGFzayB4bWxucz0iaHR0cDovL2hsNy5vcmcvZmhpciI+PGlkIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PG1ldGE+PHByb2ZpbGUgdmFsdWU9Imh0dHBzOi8vZ2VtYXRpay5kZS9maGlyL1N0cnVjdHVyZURlZmluaXRpb24vRXJ4VGFza3wxLjEuMSIvPjwvbWV0YT48ZXh0ZW5zaW9uIHVybD0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvU3RydWN0dXJlRGVmaW5pdGlvbi9QcmVzY3JpcHRpb25UeXBlIj48dmFsdWVDb2Rpbmc+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvQ29kZVN5c3RlbS9GbG93dHlwZSIvPjxjb2RlIHZhbHVlPSIxNjAiLz48ZGlzcGxheSB2YWx1ZT0iTXVzdGVyIDE2IChBcG90aGVrZW5wZmxpY2h0aWdlIEFyem5laW1pdHRlbCkiLz48L3ZhbHVlQ29kaW5nPjwvZXh0ZW5zaW9uPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL1ByZXNjcmlwdGlvbklEIi8+PHZhbHVlIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PC9pZGVudGlmaWVyPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL0FjY2Vzc0NvZGUiLz48dmFsdWUgdmFsdWU9ImMxNTU3MzNiN2QxMzJlYWQyN2FmZmFmN2JiOTUwYWIxNzBhNWIxZWIwMzE3OWU2ZGFiYWQyYjk0ZThhM2M5M2UiLz48L2lkZW50aWZpZXI+PHN0YXR1cyB2YWx1ZT0iZHJhZnQiLz48aW50ZW50IHZhbHVlPSJvcmRlciIvPjxhdXRob3JlZE9uIHZhbHVlPSIyMDIyLTA1LTE4VDE4OjU2OjQ1LjQ2MiswMDowMCIvPjxsYXN0TW9kaWZpZWQgdmFsdWU9IjIwMjItMDUtMThUMTg6NTY6NDUuNDYyKzAwOjAwIi8+PHBlcmZvcm1lclR5cGU+PGNvZGluZz48c3lzdGVtIHZhbHVlPSJ1cm46aWV0ZjpyZmM6Mzk4NiIvPjxjb2RlIHZhbHVlPSJ1cm46b2lkOjEuMi4yNzYuMC43Ni40LjU0Ii8+PGRpc3BsYXkgdmFsdWU9IsOWZmZlbnRsaWNoZSBBcG90aGVrZSIvPjwvY29kaW5nPjx0ZXh0IHZhbHVlPSLDlmZmZW50bGljaGUgQXBvdGhla2UiLz48L3BlcmZvcm1lclR5cGU+PC9UYXNrPgo=");
        Assertions.assertEquals((int)201, (int)response.statusCode());
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)response.protocol());
        Assertions.assertEquals((Object)"application/fhir+xml;charset=utf-8", (Object)response.contentType());
        Assertions.assertFalse((boolean)response.isEmptyBody(), (String)"Body is not empty");
        Assertions.assertTrue((boolean)response.bodyAsString().contains("<?xml version=\"1.0\" encoding=\"utf-8\"?>"), (String)"Body contains XML");
        Assertions.assertEquals((int)1167, (int)response.contentLength());
    }

    @Test
    void shouldNotFailOnInvalidHttpHeaderValue() {
        String exampleInnerHttp = "MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KVGVzdC1IZWFkZXI6DQpJbnZhbGlkLUhlYWRlcg0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pg0KPFRhc2sgeG1sbnM9Imh0dHA6Ly9obDcub3JnL2ZoaXIiPg==";
        HttpBResponse response = this.innerHttp.decode("MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KVGVzdC1IZWFkZXI6DQpJbnZhbGlkLUhlYWRlcg0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pg0KPFRhc2sgeG1sbnM9Imh0dHA6Ly9obDcub3JnL2ZoaXIiPg==");
        Assertions.assertEquals((int)201, (int)response.statusCode());
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)response.protocol());
        Assertions.assertEquals((Object)"application/fhir+xml;charset=utf-8", (Object)response.contentType());
        Assertions.assertFalse((boolean)response.isEmptyBody(), (String)"Body is not empty");
        Assertions.assertTrue((boolean)response.bodyAsString().contains("<?xml version=\"1.0\" encoding=\"utf-8\"?>"), (String)"Body contains XML");
        Assertions.assertEquals((int)1167, (int)response.contentLength());
        Assertions.assertFalse((boolean)response.hasHeader("Test-Header"));
        Assertions.assertFalse((boolean)response.hasHeader("Invalid-Header"));
    }

    @Test
    void shouldDecodeWithoutBody() {
        String exampleInnerHttp = "MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo";
        HttpBResponse response = this.innerHttp.decode("MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSAyMDEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo");
        Assertions.assertEquals((int)201, (int)response.statusCode());
        Assertions.assertEquals((Object)"HTTP/1.1", (Object)response.protocol());
        Assertions.assertEquals((Object)"application/fhir+xml;charset=utf-8", (Object)response.contentType());
        Assertions.assertTrue((boolean)response.bodyAsString().isEmpty(), (String)"Body is empty");
        Assertions.assertTrue((boolean)response.isEmptyBody());
    }

    @Test
    void shouldThrowOnMissingStatusCode() {
        String exampleInnerHttp = "MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pgo8VGFzayB4bWxucz0iaHR0cDovL2hsNy5vcmcvZmhpciI+PGlkIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PG1ldGE+PHByb2ZpbGUgdmFsdWU9Imh0dHBzOi8vZ2VtYXRpay5kZS9maGlyL1N0cnVjdHVyZURlZmluaXRpb24vRXJ4VGFza3wxLjEuMSIvPjwvbWV0YT48ZXh0ZW5zaW9uIHVybD0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvU3RydWN0dXJlRGVmaW5pdGlvbi9QcmVzY3JpcHRpb25UeXBlIj48dmFsdWVDb2Rpbmc+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvQ29kZVN5c3RlbS9GbG93dHlwZSIvPjxjb2RlIHZhbHVlPSIxNjAiLz48ZGlzcGxheSB2YWx1ZT0iTXVzdGVyIDE2IChBcG90aGVrZW5wZmxpY2h0aWdlIEFyem5laW1pdHRlbCkiLz48L3ZhbHVlQ29kaW5nPjwvZXh0ZW5zaW9uPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL1ByZXNjcmlwdGlvbklEIi8+PHZhbHVlIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PC9pZGVudGlmaWVyPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL0FjY2Vzc0NvZGUiLz48dmFsdWUgdmFsdWU9ImMxNTU3MzNiN2QxMzJlYWQyN2FmZmFmN2JiOTUwYWIxNzBhNWIxZWIwMzE3OWU2ZGFiYWQyYjk0ZThhM2M5M2UiLz48L2lkZW50aWZpZXI+PHN0YXR1cyB2YWx1ZT0iZHJhZnQiLz48aW50ZW50IHZhbHVlPSJvcmRlciIvPjxhdXRob3JlZE9uIHZhbHVlPSIyMDIyLTA1LTE4VDE4OjU2OjQ1LjQ2MiswMDowMCIvPjxsYXN0TW9kaWZpZWQgdmFsdWU9IjIwMjItMDUtMThUMTg6NTY6NDUuNDYyKzAwOjAwIi8+PHBlcmZvcm1lclR5cGU+PGNvZGluZz48c3lzdGVtIHZhbHVlPSJ1cm46aWV0ZjpyZmM6Mzk4NiIvPjxjb2RlIHZhbHVlPSJ1cm46b2lkOjEuMi4yNzYuMC43Ni40LjU0Ii8+PGRpc3BsYXkgdmFsdWU9IsOWZmZlbnRsaWNoZSBBcG90aGVrZSIvPjwvY29kaW5nPjx0ZXh0IHZhbHVlPSLDlmZmZW50bGljaGUgQXBvdGhla2UiLz48L3BlcmZvcm1lclR5cGU+PC9UYXNrPgo=";
        Assertions.assertThrows(VauException.class, () -> this.innerHttp.decode("MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMSEgQ3JlYXRlZA0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pgo8VGFzayB4bWxucz0iaHR0cDovL2hsNy5vcmcvZmhpciI+PGlkIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PG1ldGE+PHByb2ZpbGUgdmFsdWU9Imh0dHBzOi8vZ2VtYXRpay5kZS9maGlyL1N0cnVjdHVyZURlZmluaXRpb24vRXJ4VGFza3wxLjEuMSIvPjwvbWV0YT48ZXh0ZW5zaW9uIHVybD0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvU3RydWN0dXJlRGVmaW5pdGlvbi9QcmVzY3JpcHRpb25UeXBlIj48dmFsdWVDb2Rpbmc+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvQ29kZVN5c3RlbS9GbG93dHlwZSIvPjxjb2RlIHZhbHVlPSIxNjAiLz48ZGlzcGxheSB2YWx1ZT0iTXVzdGVyIDE2IChBcG90aGVrZW5wZmxpY2h0aWdlIEFyem5laW1pdHRlbCkiLz48L3ZhbHVlQ29kaW5nPjwvZXh0ZW5zaW9uPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL1ByZXNjcmlwdGlvbklEIi8+PHZhbHVlIHZhbHVlPSIxNjAuMDAwLjEzMC45MTkuNTAxLjgzIi8+PC9pZGVudGlmaWVyPjxpZGVudGlmaWVyPjx1c2UgdmFsdWU9Im9mZmljaWFsIi8+PHN5c3RlbSB2YWx1ZT0iaHR0cHM6Ly9nZW1hdGlrLmRlL2ZoaXIvTmFtaW5nU3lzdGVtL0FjY2Vzc0NvZGUiLz48dmFsdWUgdmFsdWU9ImMxNTU3MzNiN2QxMzJlYWQyN2FmZmFmN2JiOTUwYWIxNzBhNWIxZWIwMzE3OWU2ZGFiYWQyYjk0ZThhM2M5M2UiLz48L2lkZW50aWZpZXI+PHN0YXR1cyB2YWx1ZT0iZHJhZnQiLz48aW50ZW50IHZhbHVlPSJvcmRlciIvPjxhdXRob3JlZE9uIHZhbHVlPSIyMDIyLTA1LTE4VDE4OjU2OjQ1LjQ2MiswMDowMCIvPjxsYXN0TW9kaWZpZWQgdmFsdWU9IjIwMjItMDUtMThUMTg6NTY6NDUuNDYyKzAwOjAwIi8+PHBlcmZvcm1lclR5cGU+PGNvZGluZz48c3lzdGVtIHZhbHVlPSJ1cm46aWV0ZjpyZmM6Mzk4NiIvPjxjb2RlIHZhbHVlPSJ1cm46b2lkOjEuMi4yNzYuMC43Ni40LjU0Ii8+PGRpc3BsYXkgdmFsdWU9IsOWZmZlbnRsaWNoZSBBcG90aGVrZSIvPjwvY29kaW5nPjx0ZXh0IHZhbHVlPSLDlmZmZW50bGljaGUgQXBvdGhla2UiLz48L3BlcmZvcm1lclR5cGU+PC9UYXNrPgo="));
    }

    @Test
    void shouldThrowOnEmptyResponseBody() {
        Assertions.assertThrows(VauException.class, () -> this.innerHttp.decode(new byte[0]));
    }

    @Test
    void shouldThrowOnMissingHttpVersion() {
        String data = "Q29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04CkNvbnRlbnQtTGVuZ3RoOiAwCjw/eG1sIHZlcnNpb249IjEuMCIgZW5jb2Rpbmc9InV0Zi04Ij8+";
        Assertions.assertThrows(VauException.class, () -> this.innerHttp.decode("Q29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04CkNvbnRlbnQtTGVuZ3RoOiAwCjw/eG1sIHZlcnNpb249IjEuMCIgZW5jb2Rpbmc9InV0Zi04Ij8+"));
    }

    @Test
    void shouldThrowOnIncompleteStatusLine() {
        String data = "MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMQ0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pg==";
        Assertions.assertThrows(VauException.class, () -> this.innerHttp.decode("MSBkMjI1NDcwZTVmMzdkYzZiMWMzZjk1ZmJkNjUxYmM1YiBIVFRQLzEuMQ0KQ29udGVudC1UeXBlOiBhcHBsaWNhdGlvbi9maGlyK3htbDtjaGFyc2V0PXV0Zi04DQpDb250ZW50LUxlbmd0aDogMTE2Nw0KDQo8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/Pg=="));
    }

    @Test
    void shouldGenerateValidInnerHttp() {
        String expectedInnerHttp = "UE9TVCBUYXNrLyRjcmVhdGUgSFRUUC8xLjENClggS2V5OiBYIFZhbHVlDQpBdXRob3JpemF0aW9uOiBCZWFyZXIgSURQX1Rva2VuDQpjb250ZW50LWxlbmd0aDogNw0KDQpjb250ZW50";
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "Task/$create", List.of(new HttpHeader("X Key", "X Value"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "content");
        String encode = this.innerHttp.encode(request);
        String base64 = Base64.getEncoder().encodeToString(encode.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"UE9TVCBUYXNrLyRjcmVhdGUgSFRUUC8xLjENClggS2V5OiBYIFZhbHVlDQpBdXRob3JpemF0aW9uOiBCZWFyZXIgSURQX1Rva2VuDQpjb250ZW50LWxlbmd0aDogNw0KDQpjb250ZW50", (Object)base64);
    }

    @Test
    void shouldGenerateValidInnerHttpWithEmptyBody() {
        String expectedInnerHttp = "UE9TVCBUYXNrLyRjcmVhdGUgSFRUUC8xLjENClggS2V5OiBYIFZhbHVlDQpBdXRob3JpemF0aW9uOiBCZWFyZXIgSURQX1Rva2VuDQpjb250ZW50LWxlbmd0aDogMA0KDQo=";
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "Task/$create", List.of(new HttpHeader("X Key", "X Value"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "");
        String encode = this.innerHttp.encode(request);
        String base64 = Base64.getEncoder().encodeToString(encode.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"UE9TVCBUYXNrLyRjcmVhdGUgSFRUUC8xLjENClggS2V5OiBYIFZhbHVlDQpBdXRob3JpemF0aW9uOiBCZWFyZXIgSURQX1Rva2VuDQpjb250ZW50LWxlbmd0aDogMA0KDQo=", (Object)base64);
    }
}

