/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau.plugins;

import de.gematik.bbriccs.rest.plugins.RestObserverManager;
import de.gematik.bbriccs.rest.vau.VauEncryptionEnvelope;
import de.gematik.bbriccs.rest.vau.plugins.VauRequestObserver;
import de.gematik.bbriccs.rest.vau.plugins.VauResponseObserver;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class VauObserverManager
extends RestObserverManager {
    private final List<VauRequestObserver> vauRequestObservers;
    private final List<VauResponseObserver> vauResponseObservers;

    private VauObserverManager(VauObserverBuilder builder) {
        super((RestObserverManager.RestObserverBuilder)builder);
        this.vauRequestObservers = builder.vauRequestObservers;
        this.vauResponseObservers = builder.vauResponseObservers;
    }

    public void serveRequestObservers(VauEncryptionEnvelope request) {
        if (!this.vauRequestObservers.isEmpty()) {
            this.vauRequestObservers.parallelStream().forEach(vro -> CompletableFuture.runAsync(() -> vro.onRequest(request)).join());
        }
    }

    public void serveResponseObservers(VauEncryptionEnvelope response) {
        if (!this.vauResponseObservers.isEmpty()) {
            this.vauResponseObservers.parallelStream().forEach(vro -> CompletableFuture.runAsync(() -> vro.onResponse(response)).join());
        }
    }

    public static class VauObserverBuilder
    extends RestObserverManager.RestObserverBuilder {
        private final List<VauRequestObserver> vauRequestObservers = new LinkedList<VauRequestObserver>();
        private final List<VauResponseObserver> vauResponseObservers = new LinkedList<VauResponseObserver>();

        public VauObserverBuilder registerForRequests(VauRequestObserver vro) {
            this.vauRequestObservers.add(vro);
            return this;
        }

        public VauObserverBuilder registerForResponses(VauResponseObserver vro) {
            this.vauResponseObservers.add(vro);
            return this;
        }

        public VauObserverManager build() {
            return new VauObserverManager(this);
        }
    }
}

