/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import de.gematik.bbriccs.crypto.encryption.AesGcm;
import de.gematik.bbriccs.crypto.encryption.Ecies;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public enum VauVersion {
    V1(1, 16, 128, 35, 12, "brainpoolP256r1");

    private final int versionId;
    private final int reqIdSize;
    private final int keySize;
    private final int respSize;
    private final int ivSize;
    private final String curve;

    public char getVersionForInnerHttp() {
        return Character.forDigit(this.versionId, 10);
    }

    public byte getVersionForEncryption() {
        return (byte)this.versionId;
    }

    public AesGcm getSymmetricMethod() {
        return new AesGcm(this.getIvSize(), 16);
    }

    public Ecies getAsymmetricMethod() {
        return new Ecies(this.getVersionForEncryption(), "ecies-vau-transport".getBytes(StandardCharsets.UTF_8), this.getIvSize(), 16, this.getCurve());
    }

    @Generated
    public int getVersionId() {
        return this.versionId;
    }

    @Generated
    public int getReqIdSize() {
        return this.reqIdSize;
    }

    @Generated
    public int getKeySize() {
        return this.keySize;
    }

    @Generated
    public int getRespSize() {
        return this.respSize;
    }

    @Generated
    public int getIvSize() {
        return this.ivSize;
    }

    @Generated
    public String getCurve() {
        return this.curve;
    }

    @Generated
    private VauVersion(int versionId, int reqIdSize, int keySize, int respSize, int ivSize, String curve) {
        this.versionId = versionId;
        this.reqIdSize = reqIdSize;
        this.keySize = keySize;
        this.respSize = respSize;
        this.ivSize = ivSize;
        this.curve = curve;
    }
}

