/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.rest.vau.VauEncryptionEnvelope;
import de.gematik.bbriccs.rest.vau.VauVersion;
import de.gematik.bbriccs.rest.vau.exceptions.VauProtocolException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import lombok.Generated;

public class VauProtocol {
    private final Random rnd = new SecureRandom();
    private final ECPublicKey publicKey;
    private final SecretKey decryptionKey;
    private final VauVersion vauVersion;

    public VauProtocol(VauVersion vauVersion, ECPublicKey publicKey) {
        this.vauVersion = vauVersion;
        this.publicKey = publicKey;
        this.decryptionKey = BC.generateAESDecryptionKey((int)vauVersion.getKeySize());
    }

    public byte[] decrypt(byte[] innerHttp) throws BadPaddingException {
        return this.vauVersion.getSymmetricMethod().decrypt((Key)this.decryptionKey, innerHttp);
    }

    public VauEncryptionEnvelope encrypt(String accessToken, byte[] innerHttp) {
        byte[] symmetricalKeyHex = this.toLowerCaseHex(this.decryptionKey.getEncoded());
        byte[] requestId = this.genRequestId(this.vauVersion.getReqIdSize());
        byte[] requestIdHex = this.toLowerCaseHex(requestId);
        byte[] encrypted = this.vauVersion.getAsymmetricMethod().encrypt(this.publicKey, this.composeInnerHttp(innerHttp, this.vauVersion.getVersionForInnerHttp(), accessToken.getBytes(StandardCharsets.UTF_8), requestIdHex, symmetricalKeyHex));
        return new VauEncryptionEnvelope(this.vauVersion, this.decryptionKey, requestId, accessToken, encrypted);
    }

    private byte[] genRequestId(int size) {
        byte[] requestId = new byte[size];
        this.rnd.nextBytes(requestId);
        return requestId;
    }

    private byte[] toLowerCaseHex(byte[] data) {
        byte[] buffer = new byte[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int value = data[i] & 0xFF;
            buffer[i * 2] = this.hexMap(value / 16 % 16);
            buffer[i * 2 + 1] = this.hexMap(value % 16);
        }
        return buffer;
    }

    private byte hexMap(int intValue) {
        if (intValue >= 0 && intValue <= 9) {
            Integer integerValue = intValue + 48;
            return integerValue.byteValue();
        }
        if (intValue >= 10 && intValue <= 15) {
            Integer integerValue = intValue + 97 - 10;
            return integerValue.byteValue();
        }
        throw new VauProtocolException("parameter must be between 0 to 15");
    }

    private byte[] composeInnerHttp(byte[] innerHttp, char version, byte[] bearer, byte[] requestId, byte[] symmetricalKey) {
        int byteSpace = 32;
        int len = 2 + bearer.length + 1 + requestId.length + 1 + symmetricalKey.length + 1 + innerHttp.length;
        return ByteBuffer.allocate(len).put((byte)version).put((byte)32).put(bearer).put((byte)32).put(requestId).put((byte)32).put(symmetricalKey).put((byte)32).put(innerHttp).array();
    }

    @Generated
    public SecretKey getDecryptionKey() {
        return this.decryptionKey;
    }

    @Generated
    public VauVersion getVauVersion() {
        return this.vauVersion;
    }
}

