/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.RawHttpCodec;
import de.gematik.bbriccs.rest.headers.AuthHttpHeaderKey;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import de.gematik.bbriccs.rest.plugins.HttpBObserver;
import de.gematik.bbriccs.rest.plugins.HttpBRequestObserver;
import de.gematik.bbriccs.rest.plugins.HttpBResponseObserver;
import de.gematik.bbriccs.rest.tls.EmptyTrustManager;
import de.gematik.bbriccs.rest.vau.VauCertificateDownload;
import de.gematik.bbriccs.rest.vau.VauEncryptionEnvelope;
import de.gematik.bbriccs.rest.vau.VauProtocol;
import de.gematik.bbriccs.rest.vau.VauVersion;
import de.gematik.bbriccs.rest.vau.exceptions.MissingAuthorizationBearerException;
import de.gematik.bbriccs.rest.vau.exceptions.VauException;
import de.gematik.bbriccs.rest.vau.plugins.VauObserver;
import de.gematik.bbriccs.rest.vau.plugins.VauObserverManager;
import de.gematik.bbriccs.rest.vau.plugins.VauRequestObserver;
import de.gematik.bbriccs.rest.vau.plugins.VauResponseObserver;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.crypto.BadPaddingException;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.RequestBodyEntity;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestInstance;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VauClient
implements HttpBClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VauClient.class);
    private final UnirestInstance unirest;
    private final VauProtocol vauProtocol;
    private final RawHttpCodec rawHttpCodec;
    private final String fdBaseUrl;
    private final List<HttpHeader> staticHeader;
    private final VauObserverManager vauObserver;
    private String vauUserPseudonym = "0";

    private VauClient(VauClientBuilder builder, VauProtocol vauProtocol) {
        this.fdBaseUrl = Objects.requireNonNull(builder.url, "VauClientBuilder is missing URL");
        this.unirest = Objects.requireNonNull(builder.unirest, "VauClientBuilder is missing Unirest");
        this.staticHeader = Objects.requireNonNull(builder.headers, "VauClientBuilder is missing static headers");
        this.rawHttpCodec = Objects.requireNonNull(builder.codec, "VauClientBuilder is missing raw HTTP codec");
        this.vauProtocol = Objects.requireNonNull(vauProtocol, "VauClientBuilder is missing VAU-Protocol");
        this.vauObserver = builder.observerBuilder.build();
    }

    public void shutDown() {
        this.unirest.close();
    }

    public SecretKey symmetricKey() {
        return this.vauProtocol.getDecryptionKey();
    }

    public HttpBResponse send(HttpBRequest bRequest) {
        this.vauObserver.serveRequestObservers(bRequest);
        byte[] rawInnerHttp = this.rawHttpCodec.encode(bRequest).getBytes(StandardCharsets.UTF_8);
        String bearerToken = (String)bRequest.getBearerToken().orElseThrow(MissingAuthorizationBearerException::new);
        VauEncryptionEnvelope vauEncrypted = this.vauProtocol.encrypt(bearerToken, rawInnerHttp);
        this.vauObserver.serveRequestObservers(vauEncrypted);
        RequestBodyEntity vauRequest = this.createRequest(bRequest, vauEncrypted);
        log.info("Send VAU-Request to: {} with Request ID {}", (Object)this.getVauRequestUrl(), (Object)vauEncrypted.requestIdAsString());
        HttpResponse outerResponse = vauRequest.asBytes();
        HttpBResponse bResponse = this.createResponse(vauEncrypted, (HttpResponse<byte[]>)outerResponse);
        this.vauObserver.serveResponseObservers(bResponse);
        log.info("Received VAU-Response with Status Code {} for Request ID {} with VAU Userpseudonym: {}", new Object[]{outerResponse.getStatus(), vauEncrypted.requestIdAsString(), this.vauUserPseudonym});
        return bResponse;
    }

    private HttpBResponse createResponse(VauEncryptionEnvelope request, HttpResponse<byte[]> outerResponse) {
        this.extractUserPseudonym(outerResponse);
        String contentType = outerResponse.getHeaders().getFirst(StandardHttpHeaderKey.CONTENT_TYPE.getKey());
        boolean isOctetStream = Objects.requireNonNull(contentType).contains("octet-stream");
        if (isOctetStream) {
            return this.decryptResponse(request, outerResponse);
        }
        return this.nonEncryptedResponse(contentType, outerResponse);
    }

    private HttpBResponse decryptResponse(VauEncryptionEnvelope request, HttpResponse<byte[]> outerResponse) {
        try {
            byte[] decrypted = this.vauProtocol.decrypt((byte[])outerResponse.getBody());
            this.vauObserver.serveResponseObservers(new VauEncryptionEnvelope(request.vauVersion(), request.decryptionKey(), request.requestId(), request.accessToken(), decrypted));
            return this.rawHttpCodec.decodeResponse(decrypted);
        }
        catch (BadPaddingException e) {
            byte[] innerHttp = (byte[])outerResponse.getBody();
            String b64Body = Base64.getEncoder().encodeToString(innerHttp);
            log.error(MessageFormat.format("Error while decoding VAU inner-HTTP of length {0}\n{1}", innerHttp.length, b64Body));
            throw new VauException("Error while decoding VAU", e);
        }
    }

    private HttpBResponse nonEncryptedResponse(String contentType, HttpResponse<byte[]> outerResponse) {
        log.warn("Received VAU Response which seems to be not encrypted with content-type: '{}': forward plain content:\n{}", (Object)contentType, (Object)new String((byte[])outerResponse.getBody()));
        List<HttpHeader> headers = outerResponse.getHeaders().all().stream().map(h -> new HttpHeader(h.getName(), h.getValue())).toList();
        return new HttpBResponse(HttpVersion.HTTP_1_1, outerResponse.getStatus(), headers, (byte[])outerResponse.getBody());
    }

    private void extractUserPseudonym(HttpResponse<byte[]> outerResponse) {
        this.vauUserPseudonym = outerResponse.getHeaders().containsKey("Userpseudonym") ? outerResponse.getHeaders().getFirst("Userpseudonym") : "0";
    }

    private RequestBodyEntity createRequest(HttpBRequest request, VauEncryptionEnvelope vauEnvelope) {
        RequestBodyEntity req = this.unirest.post(this.getVauRequestUrl()).body(vauEnvelope.encrypted());
        this.setHeaders(req, request.headers());
        return req;
    }

    private void setHeaders(RequestBodyEntity req, List<HttpHeader> dynamicHeaders) {
        this.staticHeader.forEach(h -> {
            log.trace("Set static Header '{}' = '{}'", (Object)h.key(), (Object)h.value());
            req.header(h.key(), h.value());
        });
        dynamicHeaders.forEach(h -> {
            log.trace("Set dynamic Header '{}' = '{}'", (Object)h.key(), (Object)h.value());
            req.header(h.key(), h.value());
        });
    }

    private String getVauRequestUrl() {
        return this.fdBaseUrl + "/VAU/" + this.vauUserPseudonym;
    }

    public static VauClientBuilder forUrl(String url) {
        return new VauClientBuilder(url);
    }

    public static class VauClientBuilder {
        private final VauVersion vauVersion = VauVersion.V1;
        private final String url;
        private final List<HttpHeader> headers;
        private final VauObserverManager.VauObserverBuilder observerBuilder;
        private RawHttpCodec codec;
        private UnirestInstance unirest;

        private VauClientBuilder(String url) {
            this.url = url;
            this.observerBuilder = new VauObserverManager.VauObserverBuilder();
            this.headers = new LinkedList<HttpHeader>();
            this.headers.add(StandardHttpHeaderKey.CONTENT_TYPE.createHeader("application/octet-stream"));
            this.headers.add(StandardHttpHeaderKey.ACCEPT_CHARSET.createHeader("utf-8"));
            this.headers.add(StandardHttpHeaderKey.ACCEPT.createHeader("application/octet-stream"));
        }

        public VauClientBuilder usingApiKey(String apiKey) {
            this.headers.add(AuthHttpHeaderKey.X_API_KEY.createHeader(apiKey));
            return this;
        }

        public VauClientBuilder asUserAgent(String userAgent) {
            this.headers.add(StandardHttpHeaderKey.USER_AGENT.createHeader(userAgent));
            return this;
        }

        public VauClientBuilder withHeader(String key, String value) {
            return this.withHeader(new HttpHeader(key, value));
        }

        public VauClientBuilder withHeader(HttpHeader header) {
            this.headers.add(header);
            return this;
        }

        public VauClientBuilder withHeaders(List<HttpHeader> httpHeaders) {
            this.headers.addAll(httpHeaders);
            return this;
        }

        public VauClientBuilder withHttpCodec(RawHttpCodec codec) {
            this.codec = codec;
            return this;
        }

        public VauClientBuilder registerForRequests(HttpBRequestObserver ro) {
            this.observerBuilder.registerForRequests(ro);
            return this;
        }

        public VauClientBuilder registerForRequests(VauRequestObserver vro) {
            this.observerBuilder.registerForRequests(vro);
            return this;
        }

        public VauClientBuilder registerForResponses(HttpBResponseObserver ro) {
            this.observerBuilder.registerForResponses(ro);
            return this;
        }

        public VauClientBuilder registerForResponses(VauResponseObserver vro) {
            this.observerBuilder.registerForResponses(vro);
            return this;
        }

        public VauClientBuilder register(HttpBObserver rro) {
            return this.registerForRequests((HttpBRequestObserver)rro).registerForResponses((HttpBResponseObserver)rro);
        }

        public VauClientBuilder registerForVau(VauObserver vro) {
            return this.registerForRequests(vro).registerForResponses(vro);
        }

        public VauClientBuilder withoutTlsVerification() {
            EmptyTrustManager vauTrustManager = new EmptyTrustManager();
            return this.withTlsVerification(false, (X509TrustManager)vauTrustManager);
        }

        public VauClientBuilder withTlsVerification(X509TrustManager trustManager) {
            return this.withTlsVerification(true, trustManager);
        }

        private VauClientBuilder withTlsVerification(boolean verifySsl, X509TrustManager trustManager) {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            this.unirest = Unirest.spawnInstance();
            this.unirest.config().verifySsl(verifySsl).sslContext(sslCtx);
            return this;
        }

        public VauClient usingPublicKeyFromRemote() {
            String certUrl = MessageFormat.format("{0}/VAUCertificate", this.url);
            String apiKey = this.headers.stream().filter(sh -> sh.key().equalsIgnoreCase(AuthHttpHeaderKey.X_API_KEY.getKey())).map(HttpHeader::value).findFirst().orElseThrow();
            X509Certificate cert = VauCertificateDownload.downloadFrom(certUrl, apiKey);
            return this.usingPublicKey(cert);
        }

        public VauClient usingPublicKey(X509Certificate vauCertificate) {
            return this.usingPublicKey((ECPublicKey)vauCertificate.getPublicKey());
        }

        public VauClient usingPublicKey(@NonNull ECPublicKey publicKey) {
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            if (this.unirest == null) {
                this.withoutTlsVerification();
            }
            if (this.codec == null) {
                this.withHttpCodec(RawHttpCodec.defaultCodec());
            }
            VauProtocol vauProtocol = new VauProtocol(this.vauVersion, publicKey);
            return new VauClient(this, vauProtocol);
        }
    }
}

