/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import de.gematik.bbriccs.rest.vau.exceptions.VauException;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Optional;
import kong.unirest.core.GetRequest;
import kong.unirest.core.Unirest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VauCertificateDownload {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VauCertificateDownload.class);

    private VauCertificateDownload() {
        throw new IllegalAccessError("Utility class: don't use the constructor");
    }

    public static X509Certificate downloadFrom(String url, String xApiKey) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        GetRequest req = (GetRequest)Unirest.get((String)url).header("X-api-key", xApiKey);
        byte[] bytesBody = (byte[])req.asBytes().getBody();
        byte[] data = Optional.ofNullable(bytesBody).filter(body -> ((byte[])body).length > 0).orElseThrow(() -> new VauException(MessageFormat.format("Remote on {0} returned an empty body", url)));
        log.info("Received VAU-Certificate successfully from {}", (Object)url);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        try {
            return (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        }
        catch (CertificateException e) {
            throw new VauException("Error while generating VAU-Certificate from response", e);
        }
    }
}

