/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.vau;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.RawHttpCodec;
import de.gematik.bbriccs.rest.headers.AuthHttpHeaderKey;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import de.gematik.bbriccs.rest.plugins.HttpBObserver;
import de.gematik.bbriccs.rest.tls.EmptyTrustManager;
import de.gematik.bbriccs.rest.vau.VauClient;
import de.gematik.bbriccs.rest.vau.VauEncryptionEnvelope;
import de.gematik.bbriccs.rest.vau.VauVersion;
import de.gematik.bbriccs.rest.vau.exceptions.MissingAuthorizationBearerException;
import de.gematik.bbriccs.rest.vau.exceptions.VauException;
import de.gematik.bbriccs.rest.vau.plugins.VauObserver;
import de.gematik.bbriccs.rest.vau.testutils.VauCertificateGenerator;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@WireMockTest
class VauClientTest {
    @RegisterExtension
    static WireMockExtension wm1 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).build();
    private static String url;
    private X509Certificate vauCertificate;

    VauClientTest() {
    }

    @BeforeAll
    static void setup() {
        int port = wm1.getPort();
        url = "http://localhost:" + port;
    }

    @BeforeEach
    void init() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", BC.getSecurityProvider());
        keyPairGenerator.initialize(new ECGenParameterSpec(VauVersion.V1.getCurve()));
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.vauCertificate = VauCertificateGenerator.generateX509Certificate(keyPair.getPrivate(), keyPair.getPublic());
    }

    private void prepareEndpointVauCertificate() {
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/VAUCertificate")).willReturn(WireMock.aResponse().withBody(this.vauCertificate.getEncoded())));
    }

    private void prepareEndpointForInvalidVauCertificate(byte[] resBody) {
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/VAUCertificate")).willReturn(WireMock.aResponse().withBody(resBody)));
    }

    private void prepareNegativeNonEncryptedResponse(byte[] resBody, String ... resHeader) {
        LinkedList<com.github.tomakehurst.wiremock.http.HttpHeader> headerList = new LinkedList<com.github.tomakehurst.wiremock.http.HttpHeader>();
        for (int i = 0; i < resHeader.length; i += 2) {
            headerList.add(com.github.tomakehurst.wiremock.http.HttpHeader.httpHeader((String)resHeader[i], (String[])new String[]{resHeader[i + 1]}));
        }
        HttpHeaders headers = new HttpHeaders(headerList);
        wm1.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/VAU/0")).withHeader("Content-Type", WireMock.matching((String)"application/octet-stream")).willReturn(WireMock.aResponse().withStatus(500).withHeaders(headers).withBody(resBody)));
    }

    private void preparePositiveVauResponse(SecretKey key, String resBody, String ... resHeader) {
        StringBuilder headerLinesBuilder = new StringBuilder();
        for (int i = 0; i < resHeader.length; i += 2) {
            headerLinesBuilder.append(MessageFormat.format("{0}: {1}\r\n", resHeader[i], resHeader[i + 1]));
        }
        StringBuilder rb = new StringBuilder();
        rb.append("HTTP/1.1 200 OK\r\n");
        rb.append((CharSequence)headerLinesBuilder);
        rb.append(MessageFormat.format("Content-Length: {0}\r\n", resBody.length()));
        rb.append("Content-Type: application/xml\r\n\r\n");
        rb.append(resBody);
        VauVersion vauVersion = VauVersion.V1;
        byte[] encrypted = vauVersion.getSymmetricMethod().encrypt(key, rb.toString().getBytes(StandardCharsets.UTF_8));
        wm1.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/VAU/0")).withHeader("Content-Type", WireMock.matching((String)"application/octet-stream")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/octet-stream"}).withBody(encrypted)));
    }

    @Test
    void shouldHandleResponse() {
        VauClient vau = VauClient.forUrl((String)url).withHttpCodec(RawHttpCodec.defaultCodec()).withHeaders(List.of(AuthHttpHeaderKey.X_API_KEY.createHeader("testApiKey"), StandardHttpHeaderKey.USER_AGENT.createHeader("testAgent"))).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", "Userpseudonym", "0", "X-Request-Id", "testRequestId-123456");
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token"), "What's wrong, McFly? Chicken!");
        HttpBResponse response = vau.send(request);
        Assertions.assertEquals((int)200, (int)response.statusCode());
        Assertions.assertEquals((Object)"Nobody calls me chicken", (Object)response.bodyAsString());
        Assertions.assertEquals((Object)"testRequestId-123456", (Object)response.headerValue("X-Request-Id"));
        Assertions.assertDoesNotThrow(() -> ((VauClient)vau).shutDown());
    }

    @Test
    void shouldThrowOnMissingJwtToken() {
        VauClient vau = VauClient.forUrl((String)url).withHeaders(List.of(AuthHttpHeaderKey.X_API_KEY.createHeader("testApiKey"), StandardHttpHeaderKey.USER_AGENT.createHeader("testAgent"))).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", "Userpseudonym", "0", "X-Request-Id", "testRequestId-123456");
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", "What's wrong, McFly? Chicken!");
        Assertions.assertThrows(MissingAuthorizationBearerException.class, () -> vau.send(request));
    }

    @Test
    void shouldHandleUnencryptedResponse500() {
        this.prepareNegativeNonEncryptedResponse("Nobody calls me chicken".getBytes(StandardCharsets.UTF_8), "Userpseudonym", "0", "content-type", "text/plain", "X-Request-Id", "testRequestId-123456");
        VauClient vau = VauClient.forUrl((String)url).usingApiKey("testApiKey").asUserAgent("Bbriccs-Agent").withHeader("custom-header", "custom-value").usingPublicKey(this.vauCertificate);
        vau.init();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token"), "Nobody calls me chicken");
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> vau.send(request));
        Assertions.assertEquals((Object)"Nobody calls me chicken", (Object)response.bodyAsString());
    }

    @Test
    void shouldThrowOnUnencryptedOctetStream() {
        this.prepareNegativeNonEncryptedResponse("Nobody calls me chicken".getBytes(StandardCharsets.UTF_8), "Userpseudonym", "0", "content-type", "application/octet-stream", "X-Request-Id", "testRequestId-123456");
        VauClient vau = VauClient.forUrl((String)url).withHeader(AuthHttpHeaderKey.X_API_KEY.createHeader("testApiKey")).withHeader(StandardHttpHeaderKey.USER_AGENT.createHeader("testAgent")).usingPublicKey(this.vauCertificate);
        vau.init();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token"), "Nobody calls me chicken");
        Assertions.assertThrows(VauException.class, () -> vau.send(request));
    }

    @Test
    void shouldNotFailIfUserpseudonymMissing() {
        VauClient vau = VauClient.forUrl((String)url).withHeader(AuthHttpHeaderKey.X_API_KEY.createHeader("")).withHeader(StandardHttpHeaderKey.USER_AGENT.createHeader("")).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", new String[0]);
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", List.of(new HttpHeader("X-erp-user", "l"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "What's wrong, McFly? Chicken!");
        Assertions.assertDoesNotThrow(() -> vau.send(request));
    }

    @Test
    void shouldNotFailWithCustomTlsVerification() {
        VauClient vau = VauClient.forUrl((String)url).withHeader(AuthHttpHeaderKey.X_API_KEY.createHeader("")).withHeader(StandardHttpHeaderKey.USER_AGENT.createHeader("")).withTlsVerification((X509TrustManager)new EmptyTrustManager()).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", new String[0]);
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", List.of(new HttpHeader("X-erp-user", "l"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "What's wrong, McFly? Chicken!");
        Assertions.assertDoesNotThrow(() -> vau.send(request));
    }

    @Test
    void shouldNotFailIfUseragentMissing() {
        VauClient vau = VauClient.forUrl((String)url).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", new String[0]);
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", List.of(new HttpHeader("X-erp-user", "l"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "What's wrong, McFly? Chicken!");
        Assertions.assertDoesNotThrow(() -> vau.send(request));
    }

    @Test
    void shouldServeRegisteredObservers() {
        ReqResObserver httpBop = new ReqResObserver();
        VauClient vau = VauClient.forUrl((String)url).register((HttpBObserver)httpBop).registerForVau((VauObserver)httpBop).usingPublicKey(this.vauCertificate);
        vau.init();
        SecretKey secret = vau.symmetricKey();
        this.preparePositiveVauResponse(secret, "Nobody calls me chicken", new String[0]);
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/Task", List.of(new HttpHeader("X-erp-user", "l"), JwtHeaderKey.AUTHORIZATION.createHeader("IDP_Token")), "What's wrong, McFly? Chicken!");
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> vau.send(request));
        Assertions.assertEquals((int)1, (int)httpBop.requests.size());
        Assertions.assertEquals((int)1, (int)httpBop.vauRequests.size());
        Assertions.assertEquals((int)1, (int)httpBop.responses.size());
        Assertions.assertEquals((int)1, (int)httpBop.vauResponses.size());
    }

    @Test
    void shouldFailIfBaseUrlMissing() {
        VauClient.VauClientBuilder vauBuilder = VauClient.forUrl(null);
        Assertions.assertThrows(NullPointerException.class, () -> vauBuilder.usingPublicKey(this.vauCertificate));
    }

    @Test
    void shouldFailIfVauCertificateMissing() {
        VauClient.VauClientBuilder vauBuilder = VauClient.forUrl((String)url);
        Assertions.assertThrows(NullPointerException.class, () -> vauBuilder.usingPublicKey((ECPublicKey)null));
    }

    @Test
    void shouldRethrowSneakyExceptionFromSSLContext() {
        VauClient.VauClientBuilder vauBuilder = VauClient.forUrl((String)url);
        try (MockedStatic mockSslContext = Mockito.mockStatic(SSLContext.class);){
            mockSslContext.when(() -> SSLContext.getInstance("TLS")).thenThrow(NoSuchAlgorithmException.class);
            Assertions.assertThrows(NoSuchAlgorithmException.class, () -> ((VauClient.VauClientBuilder)vauBuilder).withoutTlsVerification());
        }
    }

    @Test
    void shouldRetrieveVauCertificateFromRemote() {
        this.prepareEndpointVauCertificate();
        VauClient.VauClientBuilder vauBuilder = VauClient.forUrl((String)url).usingApiKey("API-Key");
        Assertions.assertDoesNotThrow(() -> ((VauClient.VauClientBuilder)vauBuilder).usingPublicKeyFromRemote());
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldThrowOnInvalidVauCertificate(byte[] resBody) {
        this.prepareEndpointForInvalidVauCertificate(resBody);
        VauClient.VauClientBuilder vauBuilder = VauClient.forUrl((String)url).usingApiKey("API-Key");
        Assertions.assertThrows(VauException.class, () -> ((VauClient.VauClientBuilder)vauBuilder).usingPublicKeyFromRemote());
    }

    static Stream<Arguments> shouldThrowOnInvalidVauCertificate() {
        return Stream.of("HelloWorld".getBytes(StandardCharsets.UTF_8), new byte[0]).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static class ReqResObserver
    implements HttpBObserver,
    VauObserver {
        private final List<HttpBRequest> requests = new LinkedList<HttpBRequest>();
        private final List<VauEncryptionEnvelope> vauRequests = new LinkedList<VauEncryptionEnvelope>();
        private final List<HttpBResponse> responses = new LinkedList<HttpBResponse>();
        private final List<VauEncryptionEnvelope> vauResponses = new LinkedList<VauEncryptionEnvelope>();

        private ReqResObserver() {
        }

        public void onRequest(HttpBRequest request) {
            this.requests.add(request);
        }

        public void onResponse(HttpBResponse response) {
            this.responses.add(response);
        }

        public void onRequest(VauEncryptionEnvelope envelope) {
            this.vauRequests.add(envelope);
        }

        public void onResponse(VauEncryptionEnvelope envelope) {
            this.vauResponses.add(envelope);
        }
    }
}

