/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.bbriccs.utils.SingletonUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SingletonUtilTest {
    SingletonUtilTest() {
    }

    @Test
    void shouldNotInstantiate() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(SingletonUtil.class));
    }

    @Test
    void shouldResetSingleton() {
        TestSingleton i1 = TestSingleton.getInstance();
        Assertions.assertEquals((Object)i1, (Object)TestSingleton.getInstance());
        SingletonUtil.resetSingleton(TestSingleton.class);
        Assertions.assertNotEquals((Object)i1, (Object)TestSingleton.getInstance());
    }

    private static class TestSingleton {
        private static TestSingleton instance;

        private TestSingleton() {
        }

        public static TestSingleton getInstance() {
            if (instance == null) {
                instance = new TestSingleton();
            }
            return instance;
        }
    }
}

