/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import java.lang.reflect.InvocationTargetException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PrivateConstructorsUtilTest {
    PrivateConstructorsUtilTest() {
    }

    @Test
    void shouldNotHaveCallableConstructor() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(PrivateConstructorsUtil.class));
    }

    @Test
    void shouldDetectPublicConstructors() {
        Assertions.assertFalse((boolean)PrivateConstructorsUtil.isUtilityConstructor(TestClassPublicConstructor.class));
    }

    @Test
    void shouldDetectPublicConstructors02() {
        Assertions.assertFalse((boolean)PrivateConstructorsUtil.throwsOnCall(InvocationTargetException.class, TestClassPublicConstructor.class));
    }

    @Test
    void shouldThrowOnNonUtilityConstructor() {
        Assertions.assertFalse((boolean)PrivateConstructorsUtil.isUtilityConstructor(TestClassWithoutArguments.class));
    }

    @Test
    void shouldDetectExceptionCause() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.throwsOnCall(IllegalArgumentException.class, TestClassThrowingException.class));
    }

    @Test
    void shouldDetectUnexpectedExceptionCause() {
        Assertions.assertFalse((boolean)PrivateConstructorsUtil.throwsOnCall(NullPointerException.class, TestClassThrowingException.class));
    }

    private static class TestClassPublicConstructor {
    }

    private static class TestClassWithoutArguments {
        private TestClassWithoutArguments(String text) {
        }
    }

    private static class TestClassThrowingException {
        private TestClassThrowingException() {
            throw new IllegalArgumentException("don't call me");
        }
    }
}

