/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.exceptions.SmartcardException;
import de.gematik.bbriccs.konnektor.utils.BNetzAVLCa;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmcB;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.ocsp.OnlineOCSPSource;
import eu.europa.esig.dss.spi.x509.CMSSignedDataBuilder;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftKonSigner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoftKonSigner.class);
    private final CAdESService cades;
    private final CommonCertificateVerifier certVerifier = new CommonCertificateVerifier();

    public SoftKonSigner() {
        this.cades = new CAdESService((CertificateVerifier)this.certVerifier);
    }

    private static EncryptionAlgorithm getEncryptionAlgorithm(SmartcardCertificate certificate) {
        EncryptionAlgorithm ret = switch (certificate.getCryptoSystem()) {
            default -> throw new IncompatibleClassChangeError();
            case CryptoSystem.RSA_2048, CryptoSystem.RSA_PSS_2048 -> EncryptionAlgorithm.RSA;
            case CryptoSystem.ECC_256 -> EncryptionAlgorithm.ECDSA;
        };
        log.trace("Encryption Algorithm for signing from {} to {}", (Object)certificate.getCryptoSystem(), (Object)ret);
        return ret;
    }

    public byte[] signDocument(Smartcard smartcard, CryptoSystem cryptoSystem, boolean includeRevocationInfo, byte[] data) {
        if (smartcard instanceof Hba) {
            Hba hba = (Hba)smartcard;
            return this.signDocument(hba, cryptoSystem, includeRevocationInfo, data);
        }
        if (smartcard instanceof SmcB) {
            SmcB smcB = (SmcB)smartcard;
            return this.signDocument(smcB, cryptoSystem, includeRevocationInfo, data);
        }
        throw new SmartcardException(MessageFormat.format("Smartcard {0} ({1}) is not supported for Signing a document", smartcard.getType(), smartcard.getClass().getSimpleName()));
    }

    public byte[] signDocument(Hba hba, CryptoSystem cryptoSystem, boolean includeRevocationInfo, String data) {
        return this.signDocument(hba, cryptoSystem, includeRevocationInfo, data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] signDocument(Hba hba, CryptoSystem cryptoSystem, boolean includeRevocationInfo, byte[] data) {
        SmartcardCertificate certificate = hba.getQesCertificate(cryptoSystem);
        return this.signDocument(certificate, includeRevocationInfo, data);
    }

    public byte[] signDocument(SmcB smcB, CryptoSystem cryptoSystem, boolean includeRevocationInfo, String data) {
        return this.signDocument(smcB, cryptoSystem, includeRevocationInfo, data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] signDocument(SmcB smcB, CryptoSystem cryptoSystem, boolean includeRevocationInfo, byte[] data) {
        SmartcardCertificate certificate = smcB.getOSigCertificate(cryptoSystem);
        return this.signDocument(certificate, includeRevocationInfo, data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] signDocument(SmartcardCertificate certificate, boolean includeRevocationInfo, byte[] data) {
        Date signingDate = new Date();
        MimeTypeEnum mimeType = MimeTypeEnum.XML;
        log.info("Sign {} with {} Bytes at {}", new Object[]{mimeType.getMimeTypeString(), data.length, signingDate});
        log.debug("Signed Base64 Data:\n{}", (Object)Base64.toBase64String((byte[])data));
        InMemoryDocument inMemDocument = new InMemoryDocument(data);
        inMemDocument.setMimeType((MimeType)mimeType);
        try (Pkcs12SignatureToken signingToken = new Pkcs12SignatureToken((InputStream)certificate.getCertificateStream().get(), certificate.getP12KeyStoreProtection());){
            DSSPrivateKeyEntry privateKeyEntry = (DSSPrivateKeyEntry)signingToken.getKeys().get(0);
            EncryptionAlgorithm signAlgorithm = SoftKonSigner.getEncryptionAlgorithm(certificate);
            CAdESSignatureParameters signParams = this.getCAdESSignatureParameters(signingDate, privateKeyEntry, signAlgorithm);
            ToBeSigned dataToSign = this.cades.getDataToSign((DSSDocument)inMemDocument, signParams);
            SignatureValue signatureValue = signingToken.sign(dataToSign, signParams.getDigestAlgorithm(), privateKeyEntry);
            log.info("Sign XML with {}", (Object)signatureValue);
            CMSSignedDocument signedDocument = (CMSSignedDocument)this.cades.signDocument((DSSDocument)inMemDocument, signParams, signatureValue);
            if (includeRevocationInfo) {
                X509Certificate ca = BNetzAVLCa.getCA(privateKeyEntry.getCertificate().getCertificate());
                OnlineOCSPSource ocspSource = new OnlineOCSPSource();
                OCSPToken ocspToken = ocspSource.getRevocationToken(privateKeyEntry.getCertificate(), new CertificateToken(ca));
                this.certVerifier.setOcspSource((RevocationSource)ocspSource);
                CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder();
                cmsSignedDataBuilder.setOriginalCMSSignedData(signedDocument.getCMSSignedData());
                CMSSignedData cms = cmsSignedDataBuilder.extendCMSSignedData(Collections.emptyList(), Collections.emptyList(), List.of(ocspToken));
                byte[] byArray = cms.getEncoded();
                return byArray;
            }
            byte[] byArray = signedDocument.getCMSSignedData().getEncoded();
            return byArray;
        }
    }

    private CAdESSignatureParameters getCAdESSignatureParameters(Date signingDate, DSSPrivateKeyEntry privateKeyEntry, EncryptionAlgorithm encryptionAlgorithm) {
        CAdESSignatureParameters params = new CAdESSignatureParameters();
        params.bLevel().setSigningDate(signingDate);
        params.setEncryptionAlgorithm(encryptionAlgorithm);
        params.setSignatureLevel(SignatureLevel.CAdES_BASELINE_B);
        params.setSignaturePackaging(SignaturePackaging.ENVELOPING);
        params.setDigestAlgorithm(DigestAlgorithm.SHA256);
        params.setSigningCertificate(privateKeyEntry.getCertificate());
        params.setCertificateChain(privateKeyEntry.getCertificateChain());
        params.setContentHintsType(CMSAttributes.contentHint.getId());
        params.setContentHintsDescription("CMSDocument2sign");
        return params;
    }
}

