/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.KonnektorBuildInstruction;
import de.gematik.bbriccs.konnektor.KonnektorFactory;
import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.SofKonServicePort;
import de.gematik.bbriccs.konnektor.cfg.KonnektorConfiguration;
import de.gematik.bbriccs.konnektor.cfg.SoftKonServiceConfiguration;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftKonFactory
implements KonnektorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoftKonFactory.class);
    public static final String SERVICE_NAME = "Soft-Kon";

    public String getType() {
        return SERVICE_NAME;
    }

    public KonnektorBuildInstruction mapConfiguration(KonnektorConfiguration cfg) {
        SoftKonServiceConfiguration skscdto = (SoftKonServiceConfiguration)cfg.getService().castTo((KonnektorFactory)this, SoftKonServiceConfiguration.class);
        log.info("Build Konnektor-Client {} for {}", (Object)cfg.getName(), (Object)skscdto.getType());
        SmartcardArchive smartcards = SmartcardArchive.from((String)skscdto.getSmartcards());
        VsdmService vsdmService = Optional.ofNullable(skscdto.getVsdmConfiguration()).map(VsdmService::createFrom).orElseGet(VsdmService::instantiateWithTestKey);
        SofKonServicePort service = new SofKonServicePort(smartcards, vsdmService);
        return KonnektorBuildInstruction.builder().ctx(cfg.getContext().asContextType()).serviceProvider((ServicePort)service).cardTerminals(List.of()).build();
    }
}

