/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.KonnektorServiceDefinition;
import de.gematik.bbriccs.konnektor.SKAuthSignatureServicePortType;
import de.gematik.bbriccs.konnektor.SKCardServicePortType;
import de.gematik.bbriccs.konnektor.SKCertificateServicePortType;
import de.gematik.bbriccs.konnektor.SKEncryptionPortType;
import de.gematik.bbriccs.konnektor.SKEventServicePortType;
import de.gematik.bbriccs.konnektor.SKSignatureServicePortType;
import de.gematik.bbriccs.konnektor.SKVSDServicePortType;
import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.ws.conn.authsignatureservice.wsdl.v7_4.AuthSignatureServicePortType;
import de.gematik.ws.conn.cardservice.wsdl.v8.CardServicePortType;
import de.gematik.ws.conn.cardterminalservice.wsdl.v1.CardTerminalServicePortType;
import de.gematik.ws.conn.certificateservice.wsdl.v6.CertificateServicePortType;
import de.gematik.ws.conn.encryptionservice.wsdl.v6.EncryptionServicePortType;
import de.gematik.ws.conn.eventservice.wsdl.v7.EventServicePortType;
import de.gematik.ws.conn.signatureservice.wsdl.v7.SignatureServicePortType;
import de.gematik.ws.conn.vsds.vsdservice.v5.VSDServicePortType;
import java.text.MessageFormat;
import org.apache.commons.lang3.NotImplementedException;

public class SofKonServicePort
extends ServicePort {
    private final SoftKonCore softKonCore;
    private final VsdmService vsdmService;

    public SofKonServicePort(SmartcardArchive smartcardArchive, VsdmService service) {
        super(KonnektorServiceDefinition.forSoftKon());
        this.softKonCore = new SoftKonCore(smartcardArchive);
        this.vsdmService = service;
    }

    public SofKonServicePort(SmartcardArchive smartcardArchive) {
        this(smartcardArchive, VsdmService.instantiateWithTestKey());
    }

    public AuthSignatureServicePortType getAuthSignatureService() {
        return new SKAuthSignatureServicePortType(this.softKonCore);
    }

    public CertificateServicePortType getCertificateService() {
        return new SKCertificateServicePortType(this.softKonCore);
    }

    public EventServicePortType getEventService() {
        return new SKEventServicePortType(this.softKonCore);
    }

    public SignatureServicePortType getSignatureService() {
        return new SKSignatureServicePortType(this.softKonCore);
    }

    public CardServicePortType getCardService() {
        return new SKCardServicePortType(this.softKonCore);
    }

    public CardTerminalServicePortType getCardTerminalService() {
        throw new NotImplementedException("CardTerminalService not implemented yet for SoftKon");
    }

    public VSDServicePortType getVSDServicePortType() {
        return new SKVSDServicePortType(this.softKonCore, this.vsdmService);
    }

    public EncryptionServicePortType getEncryptionServicePortType() {
        return new SKEncryptionPortType(this.softKonCore);
    }

    public String toString() {
        return MessageFormat.format("{0}", this.getSds().getProductName());
    }
}

