/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.SoftKonServicePortType;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.signatureservice.v7.ComfortSignatureStatusEnum;
import de.gematik.ws.conn.signatureservice.v7.DocumentType;
import de.gematik.ws.conn.signatureservice.v7.SessionInfo;
import de.gematik.ws.conn.signatureservice.v7.SignRequest;
import de.gematik.ws.conn.signatureservice.v7.SignResponse;
import de.gematik.ws.conn.signatureservice.v7.SignatureModeEnum;
import de.gematik.ws.conn.signatureservice.v7.VerificationResultType;
import de.gematik.ws.conn.signatureservice.v7.VerifyDocument;
import de.gematik.ws.conn.signatureservice.v7.VerifyDocumentResponse;
import de.gematik.ws.conn.signatureservice.wsdl.v7.FaultMessage;
import de.gematik.ws.conn.signatureservice.wsdl.v7.SignatureServicePortType;
import de.gematik.ws.tel.error.v2.Error;
import jakarta.xml.ws.Holder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.Duration;
import oasis.names.tc.dss._1_0.core.schema.Base64Signature;
import oasis.names.tc.dss._1_0.core.schema.SignatureObject;
import org.apache.commons.lang3.NotImplementedException;

public class SKSignatureServicePortType
extends SoftKonServicePortType
implements SignatureServicePortType {
    public SKSignatureServicePortType(SoftKonCore softKonCore) {
        super(softKonCore);
    }

    public void verifyDocument(ContextType context, String tvMode, VerifyDocument.OptionalInputs optionalInputs, DocumentType document, SignatureObject signatureObject, boolean includeRevocationInfo, Holder<Status> status, Holder<VerificationResultType> verificationResult, Holder<VerifyDocumentResponse.OptionalOutputs> optionalOutputs) {
        byte[] data = signatureObject.getBase64Signature().getValue();
        boolean isValid = this.softKonCore.verifyDocument(data);
        status.value = new Status();
        if (isValid) {
            ((Status)status.value).setResult("OK");
        } else {
            ((Status)status.value).setError(new Error());
        }
        verificationResult.value = new VerificationResultType();
        ((VerificationResultType)verificationResult.value).setHighLevelResult("valid");
    }

    public List<SignResponse> signDocument(String cardHandle, String crypt, ContextType context, String tvMode, String jobNumber, List<SignRequest> signRequest) throws FaultMessage {
        ArrayList<SignResponse> response = new ArrayList<SignResponse>();
        for (SignRequest sr : signRequest) {
            byte[] signedData = this.softKonCore.signDocumentWith(cardHandle, CryptoSystem.fromString((String)crypt), sr.isIncludeRevocationInfo(), sr.getDocument().getBase64Data().getValue());
            SignResponse signResponse = new SignResponse();
            signResponse.setRequestID(sr.getRequestID());
            Status status = new Status();
            status.setResult("OK");
            signResponse.setStatus(status);
            SignatureObject signatureObject = new SignatureObject();
            Base64Signature b64Signature = new Base64Signature();
            b64Signature.setValue(signedData);
            signatureObject.setBase64Signature(b64Signature);
            signResponse.setSignatureObject(signatureObject);
            response.add(signResponse);
        }
        return response;
    }

    public String getJobNumber(ContextType context) throws FaultMessage {
        return this.softKonCore.getJobNumber(context);
    }

    public Status stopSignature(ContextType context, String jobNumber) throws FaultMessage {
        throw new NotImplementedException("Stop Signature not implemented yet");
    }

    public void activateComfortSignature(String cardHandle, ContextType context, Holder<Status> status, Holder<SignatureModeEnum> signatureMode) throws FaultMessage {
        throw new NotImplementedException("Activate ComfortSignature not implemented yet");
    }

    public Status deactivateComfortSignature(List<String> cardHandle) throws FaultMessage {
        throw new NotImplementedException("Deactivate ComfortSignature not implemented yet");
    }

    public void getSignatureMode(String cardHandle, ContextType context, Holder<Status> status, Holder<ComfortSignatureStatusEnum> comfortSignatureStatus, Holder<Integer> comfortSignatureMax, Holder<Duration> comfortSignatureTimer, Holder<SessionInfo> sessionInfo) throws FaultMessage {
        throw new NotImplementedException("Get Signature Mode not implemented yet");
    }
}

