/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.InvalidKeyLengthException;
import de.gematik.bbriccs.konnektor.exceptions.ParsingUpdateReasonException;
import de.gematik.bbriccs.konnektor.vsdm.VsdmChecksum;
import de.gematik.bbriccs.konnektor.vsdm.VsdmUpdateReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VsdmChecksumTest {
    private static final String VALID_CHECKSUM = "VDA0NjE0MjQ5OTE3MTAyNzY1NTJVVDEufU90p/1XligLKMG5VLlJrzQCyUh+JSU=";

    VsdmChecksumTest() {
    }

    @Test
    void shouldThrowOnInvalidChecksum() {
        Assertions.assertThrows(ParsingUpdateReasonException.class, () -> VsdmChecksum.parse((String)"invalid"));
    }

    @Test
    void shouldParseValidChecksum() {
        VsdmChecksum checksum = (VsdmChecksum)Assertions.assertDoesNotThrow(() -> VsdmChecksum.parse((String)VALID_CHECKSUM));
        Assertions.assertNotNull((Object)checksum);
        Assertions.assertEquals((char)'1', (char)checksum.getVersion());
        Assertions.assertEquals((char)'T', (char)checksum.getIdentifier());
        Assertions.assertEquals((Object)"T046142499", (Object)checksum.getKvnr());
        Assertions.assertEquals((Object)VsdmUpdateReason.UFS_UPDATE, (Object)checksum.getUpdateReason());
        Assertions.assertDoesNotThrow(() -> ((VsdmChecksum)checksum).toString());
    }

    @Test
    void shouldThrowOnSigningWithInvalidKeyLength() {
        VsdmChecksum checksum = (VsdmChecksum)Assertions.assertDoesNotThrow(() -> VsdmChecksum.parse((String)VALID_CHECKSUM));
        byte[] data = "hello".getBytes();
        Assertions.assertThrows(InvalidKeyLengthException.class, () -> checksum.sign(data));
    }

    @Test
    void shouldThrowOnTooShortChecksum() {
        String checkSum = VALID_CHECKSUM.substring(0, 10);
        Assertions.assertThrows(ParsingUpdateReasonException.class, () -> VsdmChecksum.parse((String)checkSum));
    }
}

