/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.utils;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.utils.BNetzAVLCa;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;

class BNetzAVLCaTest {
    BNetzAVLCaTest() {
    }

    @Test
    void certificateShouldNotNull() {
        Arrays.stream(BNetzAVLCa.values()).forEach(bNetzAVLCa -> {
            X509Certificate certificate = bNetzAVLCa.getCertificate();
            Assertions.assertNotNull((Object)certificate);
        });
    }

    @Test
    void shouldThrowExceptionWhenSubjectCANotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> BNetzAVLCa.getCA((String)"Invalid Subject CA"));
    }

    @Test
    void shouldReturnCorrectValueWhenSubjectCAExists() {
        X509Certificate bNetzAVLCa = BNetzAVLCa.getCA((String)"GEM.HBA-qCA6 TEST-ONLY");
        Assertions.assertEquals((Object)BNetzAVLCa.GEM_HBA_QCA6_TEST_ONLY.getCertificate(), (Object)bNetzAVLCa);
    }

    @Test
    void shouldThrowExceptionWhenEECertificatesNotExists() {
        X509Certificate eeCert = BNetzAVLCa.GEM_HBA_QCA24_TEST_ONLY.getCertificate();
        Assertions.assertThrows(IllegalArgumentException.class, () -> BNetzAVLCa.getCA((X509Certificate)eeCert));
    }

    @Test
    void shouldThrowExceptionWhenEECertificatesDoesNotHaveIssuerName() {
        X509Certificate eeCert = (X509Certificate)Mockito.spy((Object)BNetzAVLCa.GEM_HBA_QCA24_TEST_ONLY.getCertificate());
        X500Principal principal = (X500Principal)Mockito.mock(X500Principal.class);
        Mockito.when((Object)principal.getName()).thenReturn((Object)"O=gematik GmbH NOT-VALID,C=DE");
        Mockito.when((Object)eeCert.getIssuerX500Principal()).thenReturn((Object)principal);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> BNetzAVLCa.getCA((X509Certificate)eeCert));
        System.out.println(e.getMessage());
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class, mode=EnumSource.Mode.EXCLUDE, names={"RSA_PSS_2048"})
    void shouldReturnCertificateWhenEECertificatesIssuerExists(CryptoSystem algorithm) {
        Hba hba = SmartcardArchive.fromResources().getHba(0);
        SmartcardCertificate eeCert = hba.getQesCertificate(algorithm);
        Assertions.assertNotNull((Object)BNetzAVLCa.getCA((X509Certificate)eeCert.getX509Certificate()));
    }
}

