/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.SoftKonVerifier;
import java.util.stream.Stream;
import org.bouncycastle.util.encoders.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;

class SoftKonVerifierTest {
    private static final String SIGNED_DOC_VALID = "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";
    private static final String SIGNED_DOC_INVALID = "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";

    SoftKonVerifierTest() {
    }

    static Stream<Arguments> shouldNotThrowOnInvalidDataToVerify() {
        return Stream.of(Arguments.of((Object[])new Object[]{"HelloWorld".getBytes()}), Arguments.of((Object[])new Object[]{Base64.decode((String)SIGNED_DOC_INVALID)}), Arguments.of((Object[])new Object[]{new byte[0]}));
    }

    @ParameterizedTest
    @MethodSource
    @NullSource
    void shouldNotThrowOnInvalidDataToVerify(byte[] data) {
        SoftKonVerifier verifier = new SoftKonVerifier();
        Boolean isValid = (Boolean)Assertions.assertDoesNotThrow(() -> verifier.verify(data));
        Assertions.assertFalse((boolean)isValid);
    }

    @Test
    void shouldVerifyValidlySignedDocument() {
        byte[] data = Base64.decode((String)SIGNED_DOC_VALID);
        SoftKonVerifier verifier = new SoftKonVerifier();
        Boolean isValid = (Boolean)Assertions.assertDoesNotThrow(() -> verifier.verify(data));
        Assertions.assertTrue((boolean)isValid);
    }
}

