/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.SofKonServicePort;
import de.gematik.bbriccs.konnektor.exceptions.SmartcardException;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificateP12;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.ws.conn.certificateservice.v6.ReadCardCertificate;
import de.gematik.ws.conn.certificateservice.wsdl.v6.CertificateServicePortType;
import de.gematik.ws.conn.certificateservice.wsdl.v6.FaultMessage;
import de.gematik.ws.conn.certificateservicecommon.v2.CertRefEnum;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import jakarta.xml.ws.Holder;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class SKCertificateServicePortTypeTest {
    private static ContextType ctx;
    private static SofKonServicePort softKonServiceProvider;

    SKCertificateServicePortTypeTest() {
    }

    @BeforeAll
    static void setup() {
        SmartcardArchive smartCardArchive = SmartcardArchive.fromResources();
        softKonServiceProvider = new SofKonServicePort(smartCardArchive);
        ctx = new ContextType();
        ctx.setClientSystemId("cs1");
        ctx.setMandantId("m1");
        ctx.setUserId("u1");
        ctx.setWorkplaceId("w1");
    }

    @Test
    void shouldThrowExceptions() {
        CertificateServicePortType eventService = softKonServiceProvider.getCertificateService();
        Assertions.assertThrows(NotImplementedException.class, () -> eventService.checkCertificateExpiration("", ctx, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> eventService.verifyCertificate(ctx, null, null, null, null, null));
    }

    @Test
    void shouldThrowOnUnknownCardHandle() {
        CertificateServicePortType eventService = softKonServiceProvider.getCertificateService();
        Assertions.assertThrows(FaultMessage.class, () -> eventService.readCardCertificate("unknown", ctx, null, null, null, null));
    }

    @Test
    void shouldErrorOnInvalidSmartcardCertificates() {
        SmartcardArchive sca = (SmartcardArchive)Mockito.mock(SmartcardArchive.class);
        SmartcardConfigDto smartcardConfig = new SmartcardConfigDto();
        smartcardConfig.setIccsn("123");
        smartcardConfig.setType(SmartcardType.EGK);
        Mockito.when((Object)sca.getConfigs()).thenReturn(List.of(smartcardConfig));
        EgkP12 mockEgk = (EgkP12)Mockito.mock(EgkP12.class);
        Mockito.when((Object)((SmartcardP12)sca.getByICCSN((Class)ArgumentMatchers.eq(SmartcardP12.class), ArgumentMatchers.anyString()))).thenReturn((Object)mockEgk);
        SofKonServicePort servicePort = new SofKonServicePort(sca);
        CertificateServicePortType eventService = servicePort.getCertificateService();
        ReadCardCertificate.CertRefList certRefList = new ReadCardCertificate.CertRefList();
        certRefList.getCertRef().add(CertRefEnum.C_ENC);
        Holder status = new Holder();
        Holder dataInfoList = new Holder();
        Assertions.assertDoesNotThrow(() -> eventService.readCardCertificate("eGK_123", ctx, certRefList, null, status, dataInfoList));
        Assertions.assertNull((Object)((Status)status.value).getResult());
        Assertions.assertNotNull((Object)((Status)status.value).getError());
        Assertions.assertTrue((boolean)((Status)status.value).getError().getMessageID().contains("C_ENC is not yet implemented"));
    }

    @Test
    void shouldThrowOnInvalidAuthCertificate() throws CertificateEncodingException {
        SmartcardArchive sca = (SmartcardArchive)Mockito.mock(SmartcardArchive.class);
        SmartcardConfigDto smartcardConfig = new SmartcardConfigDto();
        smartcardConfig.setIccsn("123");
        smartcardConfig.setType(SmartcardType.EGK);
        Mockito.when((Object)sca.getConfigs()).thenReturn(List.of(smartcardConfig));
        SmartcardCertificateP12 mockSmartcardCertificate = (SmartcardCertificateP12)Mockito.mock(SmartcardCertificateP12.class);
        X509Certificate mockX509 = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)mockSmartcardCertificate.getX509Certificate()).thenReturn((Object)mockX509);
        Mockito.when((Object)mockX509.getEncoded()).thenThrow(new Throwable[]{new CertificateEncodingException()});
        EgkP12 mockEgk = (EgkP12)Mockito.mock(EgkP12.class);
        Mockito.when((Object)mockEgk.getAutCertificate()).thenReturn((Object)mockSmartcardCertificate);
        Mockito.when((Object)((SmartcardP12)sca.getByICCSN((Class)ArgumentMatchers.eq(SmartcardP12.class), ArgumentMatchers.anyString()))).thenReturn((Object)mockEgk);
        SofKonServicePort servicePort = new SofKonServicePort(sca);
        CertificateServicePortType eventService = servicePort.getCertificateService();
        ReadCardCertificate.CertRefList certRefList = new ReadCardCertificate.CertRefList();
        certRefList.getCertRef().add(CertRefEnum.C_AUT);
        Holder status = new Holder();
        Holder dataInfoList = new Holder();
        Assertions.assertThrows(SmartcardException.class, () -> eventService.readCardCertificate("eGK_123", ctx, certRefList, null, status, dataInfoList));
    }
}

