/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.cardterminal.CardInfo;
import de.gematik.bbriccs.cardterminal.CardTerminal;
import de.gematik.bbriccs.cardterminal.PinType;
import de.gematik.bbriccs.cardterminal.exceptions.PinVerificationException;
import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.Konnektor;
import de.gematik.bbriccs.konnektor.KonnektorImpl;
import de.gematik.bbriccs.konnektor.KonnektorRequest;
import de.gematik.bbriccs.konnektor.KonnektorResponse;
import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.SofKonServicePort;
import de.gematik.bbriccs.konnektor.cfg.KonnektorConfiguration;
import de.gematik.bbriccs.konnektor.cfg.KonnektorContextConfiguration;
import de.gematik.bbriccs.konnektor.cfg.KonnektorServiceConfiguration;
import de.gematik.bbriccs.konnektor.cfg.SoftKonServiceConfiguration;
import de.gematik.bbriccs.konnektor.exceptions.MissingKonnektorServiceException;
import de.gematik.bbriccs.konnektor.exceptions.SOAPRequestException;
import de.gematik.bbriccs.konnektor.exceptions.SmartcardMissmatchException;
import de.gematik.bbriccs.konnektor.requests.DecryptDocumentRequest;
import de.gematik.bbriccs.konnektor.requests.EncryptDocumentRequest;
import de.gematik.bbriccs.konnektor.requests.ExternalAuthenticateRequest;
import de.gematik.bbriccs.konnektor.requests.GetCardHandleRequest;
import de.gematik.bbriccs.konnektor.requests.ReadCardCertificateRequest;
import de.gematik.bbriccs.konnektor.requests.ReadVsdRequest;
import de.gematik.bbriccs.konnektor.requests.SignDocumentsRequest;
import de.gematik.bbriccs.konnektor.requests.SignXMLDocumentRequest;
import de.gematik.bbriccs.konnektor.requests.VerifyDocumentRequest;
import de.gematik.bbriccs.konnektor.requests.VerifyPinRequest;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.utils.ResourceLoader;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.cardservicecommon.v2.PinResponseType;
import de.gematik.ws.conn.cardservicecommon.v2.PinResultEnum;
import de.gematik.ws.conn.certificateservicecommon.v2.CertRefEnum;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class KonnektorIntegrationTest {
    private static SmartcardArchive sca;

    KonnektorIntegrationTest() {
    }

    @BeforeAll
    static void setup() {
        sca = SmartcardArchive.fromResources();
    }

    private Konnektor createTestKonnektor() {
        return this.createTestKonnektor(sca);
    }

    private Konnektor createTestKonnektor(SmartcardArchive smartcardArchive) {
        SofKonServicePort serviceProvider = new SofKonServicePort(smartcardArchive, VsdmService.instantiateWithTestKey());
        return new KonnektorImpl(KonnektorContextConfiguration.getDefaultContextType(), (ServicePort)serviceProvider, List.of());
    }

    @Test
    void shouldInstantiateSoftKon() {
        SofKonServicePort serviceProvider = new SofKonServicePort(sca, VsdmService.instantiateWithTestKey());
        ContextType ctx = KonnektorContextConfiguration.getDefaultContextType();
        Assertions.assertDoesNotThrow(() -> new KonnektorImpl(ctx, (ServicePort)serviceProvider, List.of((CardTerminal)Mockito.mock(CardTerminal.class))));
    }

    @Test
    void shouldInstantiateSoftKonFromConfig() {
        SoftKonServiceConfiguration scfg = new SoftKonServiceConfiguration();
        scfg.setType("Soft-Kon");
        scfg.setSmartcards(ResourceLoader.getFileFromResource((String)"smartcards").getAbsolutePath());
        KonnektorConfiguration cfg = new KonnektorConfiguration();
        cfg.setContext(new KonnektorContextConfiguration());
        cfg.setService((KonnektorServiceConfiguration)scfg);
        Assertions.assertDoesNotThrow(() -> Konnektor.create((KonnektorConfiguration)cfg));
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldPerformSimpleRoundtripOnSoftKonnektor(CryptoSystem cryptoSystem) {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardHandle = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forSmartcard((Smartcard)sca.getHba(0))).getPayload();
        ReadCardCertificateRequest cardAuthCertCmd = new ReadCardCertificateRequest(cardHandle, CertRefEnum.C_AUT, cryptoSystem);
        X509Certificate cardAuthCertificate = (X509Certificate)konnektor.execute((KonnektorRequest)cardAuthCertCmd).getPayload();
        Assertions.assertNotNull((Object)cardAuthCertificate);
        ReadCardCertificateRequest cardSigCertCmd = new ReadCardCertificateRequest(cardHandle, cryptoSystem);
        KonnektorResponse cardSigCertificate = konnektor.execute((KonnektorRequest)cardSigCertCmd);
        Assertions.assertNotNull((Object)cardSigCertificate);
        ReadCardCertificateRequest cardEncCertCmd = new ReadCardCertificateRequest(cardHandle, CertRefEnum.C_AUT, cryptoSystem);
        KonnektorResponse cardEncCertificate = konnektor.execute((KonnektorRequest)cardEncCertCmd);
        Assertions.assertNotNull((Object)cardEncCertificate);
        ReadCardCertificateRequest cardQesCertCmd = new ReadCardCertificateRequest(cardHandle, CertRefEnum.C_AUT, cryptoSystem);
        KonnektorResponse cardQesCertificate = konnektor.execute((KonnektorRequest)cardQesCertCmd);
        Assertions.assertNotNull((Object)cardQesCertificate);
        SignXMLDocumentRequest signCmd = new SignXMLDocumentRequest(cardHandle, "<xml>TEST</xml>", cryptoSystem);
        byte[] signRsp = (byte[])konnektor.execute((KonnektorRequest)signCmd).getPayload();
        Assertions.assertNotNull((Object)signRsp);
        Assertions.assertTrue((signRsp.length > 0 ? 1 : 0) != 0);
        VerifyDocumentRequest verifyCmd = new VerifyDocumentRequest(signRsp);
        Boolean verifyRsp = (Boolean)konnektor.execute((KonnektorRequest)verifyCmd).getPayload();
        Assertions.assertTrue((boolean)verifyRsp);
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldExternallyAuthenticate(CryptoSystem cryptoSystem) {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardHandle = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forSmartcard((Smartcard)sca.getSmcB(0))).getPayload();
        byte[] challenge = "challenge".getBytes(StandardCharsets.UTF_8);
        ExternalAuthenticateRequest extAuthCmd = new ExternalAuthenticateRequest(cardHandle, cryptoSystem, challenge);
        KonnektorResponse token = konnektor.execute((KonnektorRequest)extAuthCmd);
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((((byte[])token.getPayload()).length > 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldExternallyAuthenticateWithShortcut() {
        Konnektor konnektor = this.createTestKonnektor();
        SmcB smcb = sca.getSmcB(0);
        byte[] challenge = "challenge".getBytes(StandardCharsets.UTF_8);
        KonnektorResponse token = konnektor.externalAuthenticate((Smartcard)smcb, challenge);
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((((byte[])token.getPayload()).length > 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldCheckPinOnExternalAuthenticate() {
        SmcB smcb = sca.getSmcB(0);
        Konnektor konnektor = (Konnektor)Mockito.spy((Object)this.createTestKonnektor());
        PinResponseType pinResponseType = new PinResponseType();
        pinResponseType.setPinResult(PinResultEnum.ERROR);
        KonnektorResponse pinResponse = new KonnektorResponse((Object)pinResponseType);
        ((Konnektor)Mockito.doReturn((Object)pinResponse).when((Object)konnektor)).execute((KonnektorRequest)ArgumentMatchers.any(VerifyPinRequest.class));
        byte[] challenge = "challenge".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThrows(PinVerificationException.class, () -> konnektor.externalAuthenticate((Smartcard)smcb, challenge));
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldThrowOnExternalAuthenticateWithUnknownCardHandle(CryptoSystem cryptoSystem) {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardHandle = CardInfo.builder().handle("abc").build();
        byte[] challenge = "challenge".getBytes(StandardCharsets.UTF_8);
        ExternalAuthenticateRequest extAuthCmd = new ExternalAuthenticateRequest(cardHandle, cryptoSystem, challenge);
        Optional token = konnektor.executeSafely((KonnektorRequest)extAuthCmd);
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((boolean)token.isEmpty());
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldThrowOnExternalAuthenticateWithMissingAuthCertificate(CryptoSystem cryptoSystem) {
        SmartcardArchive mockArchive = (SmartcardArchive)Mockito.mock(SmartcardArchive.class);
        Mockito.when((Object)mockArchive.getByICCSN((Class)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenReturn(Mockito.mock(SmartcardP12.class));
        Konnektor konnektor = this.createTestKonnektor(mockArchive);
        CardInfo cardHandle = CardInfo.builder().handle("abc").build();
        byte[] challenge = "challenge".getBytes(StandardCharsets.UTF_8);
        ExternalAuthenticateRequest extAuthCmd = new ExternalAuthenticateRequest(cardHandle, cryptoSystem, challenge);
        Optional token = konnektor.executeSafely((KonnektorRequest)extAuthCmd);
        Assertions.assertNotNull((Object)token);
        Assertions.assertTrue((boolean)token.isEmpty());
    }

    @Test
    void shouldReadVsd() {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo egkHandle = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276883110000113311")).getPayload();
        CardInfo hbaHandle = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276001011699901501")).getPayload();
        ReadVsdRequest request = new ReadVsdRequest(egkHandle, hbaHandle, true, true);
        KonnektorResponse response = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)request));
        Assertions.assertNotNull((Object)response.getPayload());
    }

    @Test
    void shouldThrowOnReadVsdForUnknownSmartcard() {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfoType cit = new CardInfoType();
        cit.setCardType(CardTypeType.EGK);
        cit.setCardHandle("123");
        CardInfo egkHandle = CardInfo.fromCardInfoType((CardInfoType)cit);
        CardInfo hbaHandle = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276001011699901501")).getPayload();
        ReadVsdRequest request = new ReadVsdRequest(egkHandle, hbaHandle, true, true);
        Assertions.assertThrows(SOAPRequestException.class, () -> konnektor.execute((KonnektorRequest)request));
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldEncryptAndDecryptMessage(CryptoSystem cryptoSystem) {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardInfo = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276001011699901501")).getPayload();
        EncryptDocumentRequest encryptRequest = new EncryptDocumentRequest(cardInfo, "HelloWorld".getBytes(), cryptoSystem);
        KonnektorResponse encryptResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)encryptRequest));
        byte[] encrypted = (byte[])encryptResponse.getPayload();
        DecryptDocumentRequest decryptRequest = new DecryptDocumentRequest(cardInfo, encrypted, cryptoSystem);
        KonnektorResponse decryptResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)decryptRequest));
        byte[] decrypted = (byte[])decryptResponse.getPayload();
        Assertions.assertEquals((Object)"HelloWorld", (Object)new String(decrypted));
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class)
    void shouldSignAndVerifyDocument(CryptoSystem cryptoSystem) {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo signer = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forSmartcard((Smartcard)sca.getHba(0))).getPayload();
        SignXMLDocumentRequest signRequest = new SignXMLDocumentRequest(signer, "<xml>TEST</xml>", cryptoSystem);
        KonnektorResponse signResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)signRequest));
        byte[] signed = (byte[])signResponse.getPayload();
        VerifyDocumentRequest verifyRequest = new VerifyDocumentRequest(signed);
        KonnektorResponse verifyResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)verifyRequest));
        Assertions.assertTrue((boolean)((Boolean)verifyResponse.getPayload()));
    }

    @Test
    void shouldFailOnVerifyUnsigned() {
        Konnektor konnektor = this.createTestKonnektor();
        VerifyDocumentRequest verifyRequest = new VerifyDocumentRequest("unsigned".getBytes());
        KonnektorResponse verifyResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)verifyRequest));
        Assertions.assertFalse((boolean)((Boolean)verifyResponse.getPayload()));
    }

    @Test
    void shouldFailOnVerifyWronglySigned() throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Konnektor konnektor = this.createTestKonnektor();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.genKeyPair();
        Signature sig = Signature.getInstance("SHA1WithRSA");
        sig.initSign(keyPair.getPrivate());
        sig.update("HelloWorld".getBytes());
        byte[] signed = sig.sign();
        VerifyDocumentRequest verifyRequest = new VerifyDocumentRequest(signed);
        KonnektorResponse verifyResponse = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)verifyRequest));
        Assertions.assertFalse((boolean)((Boolean)verifyResponse.getPayload()));
    }

    @Test
    void shouldVerifyPin() {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardInfo = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276001011699901501")).getPayload();
        VerifyPinRequest request = new VerifyPinRequest(cardInfo, PinType.PIN_CH);
        KonnektorResponse response = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)request));
        Assertions.assertNotNull((Object)response.getPayload());
    }

    @Test
    void shouldSignEmptyDocumentsListWithoutThrowing() {
        Konnektor konnektor = this.createTestKonnektor();
        CardInfo cardInfo = (CardInfo)konnektor.execute((KonnektorRequest)GetCardHandleRequest.forIccsn((String)"80276001011699901501")).getPayload();
        SignDocumentsRequest request = new SignDocumentsRequest(cardInfo.getHandle(), List.of());
        KonnektorResponse response = (KonnektorResponse)Assertions.assertDoesNotThrow(() -> konnektor.execute((KonnektorRequest)request));
        Assertions.assertNotNull((Object)response.getPayload());
        Assertions.assertTrue((boolean)((List)response.getPayload()).isEmpty());
    }

    @Test
    void shouldThrowOnUnknownSmartcard() {
        Konnektor konnektor = this.createTestKonnektor();
        GetCardHandleRequest request = GetCardHandleRequest.forIccsn((String)"111111111111");
        Assertions.assertThrows(SmartcardMissmatchException.class, () -> konnektor.execute((KonnektorRequest)request));
    }

    @Test
    void shouldReceiveResponse() {
        GetCardHandleRequest mockCmd = (GetCardHandleRequest)Mockito.mock(GetCardHandleRequest.class);
        CardInfoType cit = new CardInfoType();
        cit.setIccsn("80276001011699910102");
        cit.setCardHandle("my_test_handle");
        cit.setCtId("Ct01");
        cit.setCardType(CardTypeType.HBA);
        CardInfo cardHandle = CardInfo.fromCardInfoType((CardInfoType)cit);
        Mockito.when((Object)mockCmd.execute((ContextType)ArgumentMatchers.any(), (ServicePort)ArgumentMatchers.any())).thenReturn((Object)cardHandle);
        SofKonServicePort serviceProvider = new SofKonServicePort(sca, VsdmService.instantiateWithTestKey());
        KonnektorImpl konnektor = new KonnektorImpl(KonnektorContextConfiguration.getDefaultContextType(), (ServicePort)serviceProvider, List.of());
        CardInfo response = (CardInfo)konnektor.execute((KonnektorRequest)mockCmd).getPayload();
        Assertions.assertEquals((Object)cardHandle, (Object)response);
    }

    @Test
    void shouldReceiveResponseSafely() {
        GetCardHandleRequest mockCmd = (GetCardHandleRequest)Mockito.mock(GetCardHandleRequest.class);
        CardInfoType cit = new CardInfoType();
        cit.setIccsn("80276001011699910102");
        cit.setCardHandle("my_test_handle");
        cit.setCtId("Ct01");
        cit.setCardType(CardTypeType.HBA);
        CardInfo cardHandle = CardInfo.fromCardInfoType((CardInfoType)cit);
        Mockito.when((Object)mockCmd.execute((ContextType)ArgumentMatchers.any(), (ServicePort)ArgumentMatchers.any())).thenReturn((Object)cardHandle);
        SofKonServicePort serviceProvider = new SofKonServicePort(sca, VsdmService.instantiateWithTestKey());
        KonnektorImpl konnektor = new KonnektorImpl(KonnektorContextConfiguration.getDefaultContextType(), (ServicePort)serviceProvider, List.of());
        Optional response = konnektor.executeSafely((KonnektorRequest)mockCmd);
        Assertions.assertTrue((boolean)response.isPresent());
        Assertions.assertEquals((Object)cardHandle, (Object)((KonnektorResponse)response.orElseThrow()).getPayload());
    }

    @Test
    void shouldSafelyCatchSoapErrors() {
        GetCardHandleRequest mockCmd = (GetCardHandleRequest)Mockito.mock(GetCardHandleRequest.class);
        Mockito.when((Object)mockCmd.execute((ContextType)ArgumentMatchers.any(), (ServicePort)ArgumentMatchers.any())).thenThrow(SOAPRequestException.class);
        SofKonServicePort serviceProvider = new SofKonServicePort(sca, VsdmService.instantiateWithTestKey());
        KonnektorImpl konnektor = new KonnektorImpl(KonnektorContextConfiguration.getDefaultContextType(), (ServicePort)serviceProvider, List.of());
        Optional response = (Optional)Assertions.assertDoesNotThrow(() -> konnektor.executeSafely((KonnektorRequest)mockCmd));
        Assertions.assertTrue((boolean)response.isEmpty());
    }

    @Test
    void shouldThrowOnMissingKonnektorService() {
        KonnektorConfiguration cfg = new KonnektorConfiguration();
        ConcreteKonnektorServiceConfiguration serviceCfg = new ConcreteKonnektorServiceConfiguration();
        serviceCfg.setType("UnknownService");
        cfg.setName("Test Konnektor");
        cfg.setService((KonnektorServiceConfiguration)serviceCfg);
        MissingKonnektorServiceException exception = (MissingKonnektorServiceException)Assertions.assertThrows(MissingKonnektorServiceException.class, () -> Konnektor.create((KonnektorConfiguration)cfg));
        Assertions.assertTrue((boolean)exception.getMessage().contains("UnknownService"));
    }

    private static class ConcreteKonnektorServiceConfiguration
    extends KonnektorServiceConfiguration {
        private String testField = "test field";

        @Generated
        public ConcreteKonnektorServiceConfiguration() {
        }

        @Generated
        public String getTestField() {
            return this.testField;
        }

        @Generated
        public void setTestField(String testField) {
            this.testField = testField;
        }

        @Generated
        public String toString() {
            return "KonnektorIntegrationTest.ConcreteKonnektorServiceConfiguration(testField=" + this.getTestField() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConcreteKonnektorServiceConfiguration)) {
                return false;
            }
            ConcreteKonnektorServiceConfiguration other = (ConcreteKonnektorServiceConfiguration)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$testField = this.getTestField();
            String other$testField = other.getTestField();
            return !(this$testField == null ? other$testField != null : !this$testField.equals(other$testField));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConcreteKonnektorServiceConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $testField = this.getTestField();
            result = result * 59 + ($testField == null ? 43 : $testField.hashCode());
            return result;
        }
    }
}

