/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.CardHandleMapper;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CardHandleMapperTest {
    CardHandleMapperTest() {
    }

    static Stream<Arguments> shouldMapSmartcardType() {
        return Stream.of(Arguments.of((Object[])new Object[]{SmartcardType.EGK, CardTypeType.EGK}), Arguments.of((Object[])new Object[]{SmartcardType.SMC_B, CardTypeType.SMC_B}), Arguments.of((Object[])new Object[]{SmartcardType.HBA, CardTypeType.HBA}), Arguments.of((Object[])new Object[]{SmartcardType.SMC_KT, CardTypeType.SMC_KT}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldMapSmartcardType(SmartcardType input, CardTypeType expected) {
        SmartcardConfigDto sccfg = new SmartcardConfigDto();
        sccfg.setType(input);
        CardHandleMapper chm = (CardHandleMapper)Assertions.assertDoesNotThrow(() -> new CardHandleMapper(List.of(sccfg)));
        Assertions.assertEquals((int)1, (int)chm.getCards().getCard().size());
        Assertions.assertEquals((Object)expected, (Object)((CardInfoType)chm.getCards().getCard().get(0)).getCardType());
    }

    @Test
    void shouldGetIccsnByCardHandle() {
        String iccsn = "123123123123";
        SmartcardConfigDto sccfg = new SmartcardConfigDto();
        sccfg.setType(SmartcardType.EGK);
        sccfg.setIccsn("123123123123");
        CardHandleMapper chm = (CardHandleMapper)Assertions.assertDoesNotThrow(() -> new CardHandleMapper(List.of(sccfg)));
        Assertions.assertEquals((int)1, (int)chm.getCards().getCard().size());
        Assertions.assertEquals((Object)"123123123123", (Object)chm.getIccsnByCardHandle(MessageFormat.format("{0}_{1}", sccfg.getType(), "123123123123")));
    }
}

