/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.InvalidKeyLengthException;
import de.gematik.bbriccs.konnektor.exceptions.ParsingUpdateReasonException;
import de.gematik.bbriccs.konnektor.vsdm.VsdmUpdateReason;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

public class VsdmChecksum {
    private final String kvnr;
    private Instant timestamp = Instant.now();
    private VsdmUpdateReason updateReason = VsdmUpdateReason.UFS_UPDATE;
    private char identifier;
    private char version;

    public VsdmChecksum setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public VsdmChecksum setUpdateReason(VsdmUpdateReason reason) {
        this.updateReason = reason;
        return this;
    }

    public VsdmChecksum setIdentifier(char identifier) {
        this.identifier = identifier;
        return this;
    }

    public VsdmChecksum setVersion(char version) {
        this.version = version;
        return this;
    }

    public static VsdmChecksum parse(String checksumAsBase64) throws ParsingUpdateReasonException {
        byte[] checksum = Base64.getDecoder().decode(checksumAsBase64.getBytes(StandardCharsets.UTF_8));
        String kvnr = new String(VsdmChecksum.copyByteArrayFrom(checksum, 0, 10), StandardCharsets.UTF_8);
        Instant timestamp = Instant.ofEpochSecond(Long.parseLong(new String(VsdmChecksum.copyByteArrayFrom(checksum, 10, 20), StandardCharsets.UTF_8)));
        VsdmUpdateReason reason = VsdmUpdateReason.fromChecksum(VsdmChecksum.copyCharFrom(checksum, 20));
        char identifier = VsdmChecksum.copyCharFrom(checksum, 21);
        char version = VsdmChecksum.copyCharFrom(checksum, 22);
        return new VsdmChecksum(kvnr).setTimestamp(timestamp).setUpdateReason(reason).setIdentifier(identifier).setVersion(version);
    }

    private static byte[] copyByteArrayFrom(byte[] data, int from, int to) throws ParsingUpdateReasonException {
        try {
            return Arrays.copyOfRange(data, from, to);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParsingUpdateReasonException(data, from, to);
        }
    }

    private static char copyCharFrom(byte[] data, int pos) {
        return (char)data[pos];
    }

    public String sign(byte[] key) {
        if (key.length != 32) {
            throw new InvalidKeyLengthException(key, 32);
        }
        HMac hMac = new HMac((Digest)new SHA256Digest());
        hMac.init((CipherParameters)new KeyParameter(key));
        byte[] data = this.genPayload().getBytes(StandardCharsets.UTF_8);
        hMac.update(data, 0, data.length);
        byte[] signature = new byte[hMac.getMacSize()];
        hMac.doFinal(signature, 0);
        byte[] checksum = new byte[data.length + 24];
        System.arraycopy(data, 0, checksum, 0, data.length);
        System.arraycopy(signature, 0, checksum, data.length, 24);
        return Base64.getEncoder().encodeToString(checksum);
    }

    private String genPayload() {
        return this.kvnr + this.timestamp.getEpochSecond() + this.updateReason.getIdentifier() + this.identifier + this.version;
    }

    public String toString() {
        return "VsdmChecksum{kvnr='" + this.kvnr + "', timestamp=" + String.valueOf(this.timestamp) + ", updateReason=" + String.valueOf((Object)this.updateReason) + ", identifier=" + this.identifier + ", version=" + this.version + "}";
    }

    @Generated
    VsdmChecksum(String kvnr) {
        this.kvnr = kvnr;
    }

    @Generated
    public String getKvnr() {
        return this.kvnr;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public VsdmUpdateReason getUpdateReason() {
        return this.updateReason;
    }

    @Generated
    public char getIdentifier() {
        return this.identifier;
    }

    @Generated
    public char getVersion() {
        return this.version;
    }
}

