/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.utils.BNetzAVLCa;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.service.ocsp.OnlineOCSPSource;
import eu.europa.esig.dss.simplereport.SimpleReport;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonTrustedCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.reports.Reports;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoftKonVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoftKonVerifier.class);

    public boolean verify(byte[] input) {
        boolean isCompletelyValid = true;
        try {
            CommonCertificateVerifier cv = new CommonCertificateVerifier();
            cv.setOcspSource((RevocationSource)new OnlineOCSPSource());
            CommonTrustedCertificateSource trustedCertSource = new CommonTrustedCertificateSource();
            for (BNetzAVLCa ca : BNetzAVLCa.values()) {
                trustedCertSource.addCertificate(new CertificateToken(ca.getCertificate()));
            }
            cv.setTrustedCertSources(new CertificateSource[]{trustedCertSource});
            SignedDocumentValidator documentValidator = SignedDocumentValidator.fromDocument((DSSDocument)new InMemoryDocument(input));
            documentValidator.setCertificateVerifier((CertificateVerifier)cv);
            Reports reports = documentValidator.validateDocument();
            SimpleReport report = reports.getSimpleReport();
            List signatures = documentValidator.getSignatures();
            for (AdvancedSignature signature : signatures) {
                boolean signatureIsValid = report.isValid(signature.getId()) || report.getIndication(signature.getId()) == Indication.INDETERMINATE;
                isCompletelyValid = isCompletelyValid && signatureIsValid;
                CertificateToken signingCertToken = signature.getSigningCertificateToken();
                CertificateToken caToken = new CertificateToken(BNetzAVLCa.getCA(signingCertToken.getCertificate()));
                RevocationToken ocsp = signature.getOCSPSource().getRevocationToken(signingCertToken, caToken);
                if (ocsp != null) {
                    log.info("Ocsp Status for signing certificate with {} is {}", (Object)signingCertToken.getSubject().getCanonical(), (Object)ocsp.getStatus());
                }
                log.info("CAdES signature signed by {} is {}valid", (Object)report.getSignedBy(signature.getId()), (Object)(!signatureIsValid ? "in" : ""));
            }
        }
        catch (Throwable t) {
            isCompletelyValid = false;
            log.warn("Failed to verify with a certificate exception", t);
        }
        return isCompletelyValid;
    }
}

