/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservice.v8.Cards;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import one.util.streamex.EntryStream;

public class CardHandleMapper {
    private final Cards cards = new Cards();
    private final Map<String, CardInfoType> cardsMap;

    public CardHandleMapper(SmartcardArchive sca) {
        this(sca.getConfigs());
    }

    public CardHandleMapper(List<SmartcardConfigDto> smartcardConfigDtos) {
        List cardInfos = EntryStream.of(smartcardConfigDtos).mapKeyValue(CardHandleMapper::createCardInfoType).toList();
        this.cardsMap = cardInfos.stream().collect(Collectors.toMap(CardInfoType::getCardHandle, cit -> cit));
        this.cards.getCard().addAll(cardInfos);
    }

    public String getIccsnByCardHandle(String cardHandle) {
        return this.cardsMap.get(cardHandle).getIccsn();
    }

    private static CardInfoType createCardInfoType(int slotId, SmartcardConfigDto scfg) {
        CardInfoType cit = new CardInfoType();
        cit.setCardType(CardHandleMapper.mapSmartcardType(scfg.getType()));
        cit.setIccsn(scfg.getIccsn());
        cit.setCardHandle(CardHandleMapper.createCardHandleString(scfg));
        cit.setSlotId(BigInteger.valueOf(slotId));
        cit.setCtId("SoftKonKT");
        if (scfg.getType().equals((Object)SmartcardType.EGK)) {
            cit.setKvnr(scfg.getIdentifier());
        }
        return cit;
    }

    private static CardTypeType mapSmartcardType(SmartcardType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SmartcardType.EGK -> CardTypeType.EGK;
            case SmartcardType.SMC_B -> CardTypeType.SMC_B;
            case SmartcardType.HBA -> CardTypeType.HBA;
            case SmartcardType.SMC_KT -> CardTypeType.SMC_KT;
        };
    }

    private static String createCardHandleString(SmartcardConfigDto scfg) {
        return MessageFormat.format("{0}_{1}", scfg.getType(), scfg.getIccsn());
    }

    @Generated
    public Cards getCards() {
        return this.cards;
    }

    @Generated
    public Map<String, CardInfoType> getCardsMap() {
        return this.cardsMap;
    }
}

