/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.ParsingUpdateReasonException;
import java.text.MessageFormat;
import java.util.Arrays;
import lombok.Generated;

public enum VsdmUpdateReason {
    UFS_UPDATE('U', "Update Flag Service (UFS) Anfrage"),
    VSD_UPDATE('V', "Versichertenstammdaten (VSD) Update"),
    CARD_MANAGEMENT_UPDATE('C', "Kartenmanagement (CMS) Update"),
    INVALID('I', "Invalid Reason (Test purpose)");

    private final String description;
    private final char identifier;

    private VsdmUpdateReason(char identifier, String description) {
        this.identifier = identifier;
        this.description = description;
    }

    public static VsdmUpdateReason fromChecksum(char value) throws ParsingUpdateReasonException {
        return Arrays.stream(VsdmUpdateReason.values()).filter(reason -> reason.getIdentifier() == value).findFirst().orElseThrow(() -> new ParsingUpdateReasonException(value));
    }

    public String toString() {
        return MessageFormat.format("Identifier {0} Description: {1}", Character.valueOf(this.identifier), this.description);
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public char getIdentifier() {
        return this.identifier;
    }
}

