/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.cfg.VsdmServiceConfiguration;
import de.gematik.bbriccs.konnektor.vsdm.VsdmChecksum;
import java.util.Base64;
import lombok.Generated;

public class VsdmService {
    private final byte[] hMacKey;
    private final char operator;
    private final char version;

    public static VsdmService createFrom(VsdmServiceConfiguration config) {
        return new VsdmService(Base64.getDecoder().decode(config.getHMacKey()), config.getOperator().charAt(0), config.getVersion().charAt(0));
    }

    public static VsdmService instantiateWithTestKey() {
        return new VsdmService(new byte[32], 's', '1');
    }

    public VsdmChecksum checksumFor(String kvnr) {
        return new VsdmChecksum(kvnr).setVersion(this.version).setIdentifier(this.operator);
    }

    public VsdmChecksum checksumWithInvalidManufacturer(String kvnr) {
        return new VsdmChecksum(kvnr).setVersion(this.version).setIdentifier('y');
    }

    public VsdmChecksum checksumWithInvalidVersion(String kvnr) {
        return new VsdmChecksum(kvnr).setVersion('0').setIdentifier(this.operator);
    }

    public String sign(VsdmChecksum checksum) {
        return checksum.sign(this.hMacKey);
    }

    @Generated
    private VsdmService(byte[] hMacKey, char operator, char version) {
        this.hMacKey = hMacKey;
        this.operator = operator;
        this.version = version;
    }
}

