/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.ParsingExamEvidenceException;
import de.gematik.bbriccs.konnektor.vsdm.VsdmChecksum;
import de.gematik.bbriccs.konnektor.vsdm.VsdmExamEvidenceResult;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import de.gematik.bbriccs.konnektor.vsdm.VsdmUpdateReason;
import de.gematik.bbriccs.smartcards.Egk;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"ts", "e", "pz"})
@XmlRootElement(name="PN")
public class VsdmExamEvidence {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VsdmExamEvidence.class);
    @XmlElement(name="TS", required=true)
    private String ts;
    @XmlElement(name="E", required=true)
    private BigInteger e;
    @XmlElement(name="PZ")
    private String pz;
    @XmlAttribute(name="CDM_VERSION")
    private String cdmVersion;

    public static VsdmExamEvidence parse(String examEvidenceAsBase64) throws ParsingExamEvidenceException {
        byte[] decode = Base64.getDecoder().decode(examEvidenceAsBase64.getBytes());
        try {
            String decompress = VsdmExamEvidence.decompress(decode);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{VsdmExamEvidence.class});
            Unmarshaller jaxbUnMarshaller = jaxbContext.createUnmarshaller();
            return (VsdmExamEvidence)jaxbUnMarshaller.unmarshal((Reader)new StringReader(decompress));
        }
        catch (JAXBException | IOException e) {
            throw new ParsingExamEvidenceException(examEvidenceAsBase64);
        }
    }

    private static String decompress(byte[] data) throws IOException {
        StringBuilder ret = new StringBuilder();
        try (GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(data));){
            ret.append(new String(in.readAllBytes()));
        }
        return ret.toString();
    }

    public static VsdmExamEvidenceBuilder asOnlineMode(VsdmService service, Egk egk) {
        return new VsdmExamEvidenceBuilder(service, egk);
    }

    public static VsdmExamEvidenceBuilder asOnlineTestMode(Egk egk) {
        return new VsdmExamEvidenceBuilder(VsdmService.instantiateWithTestKey(), egk);
    }

    public static VsdmExamEvidenceBuilder asOfflineMode() {
        return new VsdmExamEvidenceBuilder();
    }

    public String asXml() {
        StringWriter ret = new StringWriter();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{VsdmExamEvidence.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        jaxbMarshaller.marshal((Object)this, (Writer)ret);
        return ret.toString();
    }

    public Optional<String> getChecksum() {
        return this.pz != null ? Optional.of(this.pz) : Optional.empty();
    }

    public byte[] encode() {
        return this.compress(this.asXml().getBytes(StandardCharsets.UTF_8));
    }

    private byte[] compress(byte[] data) {
        ByteArrayOutputStream baos;
        try (ByteArrayOutputStream byteArrayOutputStream = baos = new ByteArrayOutputStream();
             GZIPOutputStream out = new GZIPOutputStream(baos);){
            out.write(data);
        }
        return baos.toByteArray();
    }

    public String encodeAsBase64() {
        return Base64.getEncoder().encodeToString(this.encode());
    }

    public String toString() {
        return "VsdmExamEvidence{ts='" + this.ts + "', e=" + this.e + ", pz='" + this.pz + "', cdmVersion='" + this.cdmVersion + "'}";
    }

    @Generated
    public VsdmExamEvidence() {
    }

    @Generated
    public VsdmExamEvidence(String ts, BigInteger e, String pz, String cdmVersion) {
        this.ts = ts;
        this.e = e;
        this.pz = pz;
        this.cdmVersion = cdmVersion;
    }

    @Generated
    public String getTs() {
        return this.ts;
    }

    @Generated
    public BigInteger getE() {
        return this.e;
    }

    @Generated
    public String getPz() {
        return this.pz;
    }

    @Generated
    public String getCdmVersion() {
        return this.cdmVersion;
    }

    public static class VsdmExamEvidenceBuilder {
        private final VsdmService vsdmService;
        private final Egk egk;
        private final DateTimeFormatter timestampFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneId.from(ZoneOffset.UTC));
        private VsdmChecksum checksum;
        private Instant timestamp = Instant.now();

        protected VsdmExamEvidenceBuilder(VsdmService service, Egk egk) {
            this.vsdmService = service;
            this.egk = egk;
        }

        protected VsdmExamEvidenceBuilder() {
            this(null, null);
        }

        public VsdmExamEvidenceBuilder withExpiredTimestamp() {
            this.timestamp = this.timestamp.minus(30L, ChronoUnit.MINUTES).minus(1L, ChronoUnit.SECONDS);
            if (this.isOnlineMode()) {
                this.checksum.setTimestamp(this.timestamp);
            }
            return this;
        }

        public VsdmExamEvidenceBuilder withInvalidTimestamp() {
            this.timestamp = this.timestamp.plus(31L, ChronoUnit.MINUTES);
            if (this.isOnlineMode()) {
                this.checksum.setTimestamp(this.timestamp);
            }
            return this;
        }

        public VsdmExamEvidenceBuilder checksumWithInvalidManufacturer() {
            if (this.isOnlineMode()) {
                this.checksum = this.vsdmService.checksumWithInvalidManufacturer(this.egk.getKvnr());
            }
            return this;
        }

        public VsdmExamEvidenceBuilder checksumWithInvalidVersion() {
            if (this.isOnlineMode()) {
                this.checksum = this.vsdmService.checksumWithInvalidVersion(this.egk.getKvnr());
            }
            return this;
        }

        public VsdmExamEvidenceBuilder checksumWithUpdateReason(VsdmUpdateReason reason) {
            if (this.isOnlineMode()) {
                this.checksum.setUpdateReason(reason);
            }
            return this;
        }

        private boolean isOnlineMode() {
            if (this.checksum == null && this.vsdmService != null) {
                this.checksum = this.vsdmService.checksumFor(this.egk.getKvnr());
            }
            return this.vsdmService != null;
        }

        public VsdmExamEvidenceBuilder checksumWithInvalidKvnr() {
            if (this.isOnlineMode()) {
                this.checksum = this.vsdmService.checksumFor("ABC");
            }
            return this;
        }

        public VsdmExamEvidence generate(VsdmExamEvidenceResult result) {
            return new VsdmExamEvidence(this.timestampFormatter.format(this.timestamp), BigInteger.valueOf(result.getResult()), this.isOnlineMode() ? this.vsdmService.sign(this.checksum) : null, "1.0.0");
        }
    }
}

