/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.utils;

import de.gematik.bbriccs.crypto.certificate.X509CertificateWrapper;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import lombok.Generated;

public enum BNetzAVLCa {
    GEM_HBA_QCA6_TEST_ONLY("GEM.HBA-qCA6 TEST-ONLY"),
    GEM_HBA_QCA24_TEST_ONLY("GEM.HBA-qCA24 TEST-ONLY"),
    GEM_HBA_QCA51_TEST_ONLY("GEM.HBA-qCA51 TEST-ONLY");

    private final String subjectCA;

    public static X509Certificate getCA(String subjectCN) {
        return Arrays.stream(BNetzAVLCa.values()).filter(bNetzAVLCa -> bNetzAVLCa.subjectCA.equalsIgnoreCase(subjectCN)).map(BNetzAVLCa::getCertificate).findFirst().orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("No BNetzAVL CA found with subjectCN: {0}", subjectCN)));
    }

    public static X509Certificate getCA(X509Certificate eeCert) {
        X509CertificateWrapper certWrapper = new X509CertificateWrapper(eeCert);
        return certWrapper.getIssuerCN().map(BNetzAVLCa::getCA).orElseThrow(() -> new IllegalArgumentException(MessageFormat.format("No BNetzAVL CA found for ee-certificate: {0}", eeCert.getSubjectX500Principal())));
    }

    public X509Certificate getCertificate() {
        String value = ResourceLoader.readFileFromResource((String)MessageFormat.format("ca/{0}.pem", this.subjectCA.toLowerCase().replace(" ", "_")));
        return X509CertificateWrapper.fromPem((String)value).toCertificate();
    }

    @Generated
    private BNetzAVLCa(String subjectCA) {
        this.subjectCA = subjectCA;
    }
}

