/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.CardHandleMapper;
import de.gematik.bbriccs.konnektor.SoftKonSigner;
import de.gematik.bbriccs.konnektor.SoftKonVerifier;
import de.gematik.bbriccs.smartcards.InstituteSmartcardP12;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.exceptions.CardNotFoundException;
import de.gematik.ws.conn.cardservice.v8.Cards;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.signatureservice.wsdl.v7.FaultMessage;
import de.gematik.ws.tel.error.v2.Error;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Optional;
import javax.xml.datatype.DatatypeFactory;

public class SoftKonCore {
    private final SmartcardArchive smartcards;
    private final SoftKonSigner signer;
    private final SoftKonVerifier verifier;
    private final CardHandleMapper cardsProvider;
    private int jobNumber = 0;

    public SoftKonCore(SmartcardArchive smartcards) {
        this.smartcards = smartcards;
        this.signer = new SoftKonSigner();
        this.verifier = new SoftKonVerifier();
        this.cardsProvider = new CardHandleMapper(smartcards);
    }

    public Cards getAllCards() {
        return this.cardsProvider.getCards();
    }

    public <T extends Smartcard> Optional<T> getSmartcardByCardHandleSafely(Class<T> type, String handle) {
        return Optional.ofNullable(this.cardsProvider.getCardsMap().get(handle)).map(cit -> this.smartcards.getByICCSN(type, cit.getIccsn()));
    }

    public <T extends Smartcard> T getSmartcardByCardHandle(Class<T> type, String handle) {
        return (T)((Smartcard)this.getSmartcardByCardHandleSafely(type, handle).orElseThrow(() -> new CardNotFoundException(MessageFormat.format("{0} with Handle {1} not found", type.getSimpleName(), handle))));
    }

    public byte[] signDocumentWith(String cardHandle, CryptoSystem cryptoSystem, boolean isIncludeRevocationInfo, byte[] data) throws FaultMessage {
        SmartcardP12 smartcard = this.getSmartcardByCardHandleSafely(SmartcardP12.class, cardHandle).orElseThrow(() -> new FaultMessage(MessageFormat.format("No card found with CardHandle {0}", cardHandle), this.createError(cardHandle)));
        if (smartcard instanceof InstituteSmartcardP12) {
            return this.signer.signDocument((Smartcard)smartcard, cryptoSystem, isIncludeRevocationInfo, data);
        }
        throw new FaultMessage(MessageFormat.format("Given CardHandle {0} does not belong to a institute card", cardHandle), this.createError(cardHandle));
    }

    public boolean verifyDocument(byte[] data) {
        return this.verifier.verify(data);
    }

    public String getJobNumber(ContextType context) {
        return String.format("SOFT-KON-%03d", this.jobNumber++);
    }

    public Error createError(String messageId) {
        Error error = new Error();
        error.setMessageID(messageId);
        error.setTimestamp(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        return error;
    }
}

