/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.SoftKonServicePortType;
import de.gematik.bbriccs.konnektor.vsdm.VsdmExamEvidence;
import de.gematik.bbriccs.konnektor.vsdm.VsdmExamEvidenceResult;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.vsds.vsdservice.v5.FaultMessage;
import de.gematik.ws.conn.vsds.vsdservice.v5.VSDServicePortType;
import de.gematik.ws.conn.vsds.vsdservice.v5.VSDStatusType;
import jakarta.xml.ws.Holder;
import java.text.MessageFormat;

public class SKVSDServicePortType
extends SoftKonServicePortType
implements VSDServicePortType {
    private static final String EMPTY = "empty";
    private final VsdmService vsdmService;

    public SKVSDServicePortType(SoftKonCore softKonCore, VsdmService vsdmService) {
        super(softKonCore);
        this.vsdmService = vsdmService;
    }

    public void readVSD(String ehcHandle, String hpcHandle, boolean performOnlineCheck, boolean readOnlineReceipt, ContextType context, Holder<byte[]> persoenlicheVersichertendaten, Holder<byte[]> allgemeineVersicherungsdaten, Holder<byte[]> geschuetzteVersichertendaten, Holder<VSDStatusType> vsdStatus, Holder<byte[]> pruefungsnachweis) throws FaultMessage {
        EgkP12 egk = this.softKonCore.getSmartcardByCardHandleSafely(EgkP12.class, ehcHandle).orElseThrow(() -> new FaultMessage(MessageFormat.format("No {0} found with CardHandle {1}", EgkP12.class.getSimpleName(), ehcHandle), this.softKonCore.createError(ehcHandle)));
        persoenlicheVersichertendaten.value = EMPTY.getBytes();
        allgemeineVersicherungsdaten.value = EMPTY.getBytes();
        geschuetzteVersichertendaten.value = EMPTY.getBytes();
        pruefungsnachweis.value = VsdmExamEvidence.asOnlineMode(this.vsdmService, (Egk)egk).generate(VsdmExamEvidenceResult.NO_UPDATES).encode();
        vsdStatus.value = new VSDStatusType();
        ((VSDStatusType)vsdStatus.value).setStatus("0");
        ((VSDStatusType)vsdStatus.value).setVersion("5.2.0");
    }
}

