/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.encryption.cms.CmsAuthEnvelopedData;
import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.SoftKonServicePortType;
import de.gematik.bbriccs.smartcards.InstituteSmartcard;
import de.gematik.bbriccs.smartcards.InstituteSmartcardP12;
import de.gematik.ws.conn.connectorcommon.v5.DocumentType;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.encryptionservice.v6.EncryptDocument;
import de.gematik.ws.conn.encryptionservice.v6.KeyOnCardType;
import de.gematik.ws.conn.encryptionservice.wsdl.v6.EncryptionServicePortType;
import jakarta.xml.ws.Holder;
import java.util.List;
import oasis.names.tc.dss._1_0.core.schema.Base64Data;

public class SKEncryptionPortType
extends SoftKonServicePortType
implements EncryptionServicePortType {
    public SKEncryptionPortType(SoftKonCore softKonCore) {
        super(softKonCore);
    }

    public void encryptDocument(ContextType context, EncryptDocument.RecipientKeys recipientKeys, Holder<DocumentType> document, EncryptDocument.OptionalInputs optionalInputs, Holder<Status> status, Holder<Object> optionalOutputs) {
        String cardHandle = recipientKeys.getCertificateOnCard().getCardHandle();
        InstituteSmartcard smartcard = this.softKonCore.getSmartcardByCardHandle(InstituteSmartcard.class, cardHandle);
        byte[] plain = ((DocumentType)document.value).getBase64Data().getValue();
        CryptoSystem algorithm = CryptoSystem.RSA_2048;
        CmsAuthEnvelopedData cmsAuthEnvelopedData = new CmsAuthEnvelopedData();
        byte[] decrypted = cmsAuthEnvelopedData.encrypt(List.of(smartcard.getEncCertificate(algorithm).getX509Certificate()), plain);
        Base64Data base64Data = new Base64Data();
        base64Data.setValue(decrypted);
        ((DocumentType)document.value).setBase64Data(base64Data);
    }

    public void decryptDocument(ContextType context, KeyOnCardType privateKeyOnCard, Holder<DocumentType> document, Object optionalInputs, Holder<Status> status, Holder<Object> optionalOutputs) {
        String cardHandle = privateKeyOnCard.getCardHandle();
        InstituteSmartcardP12 smartcard = this.softKonCore.getSmartcardByCardHandle(InstituteSmartcardP12.class, cardHandle);
        byte[] encrypted = ((DocumentType)document.value).getBase64Data().getValue();
        CryptoSystem algorithm = CryptoSystem.RSA_2048;
        CmsAuthEnvelopedData cmsAuthEnvelopedData = new CmsAuthEnvelopedData();
        byte[] decrypted = cmsAuthEnvelopedData.decrypt(smartcard.getEncCertificate(algorithm).getPrivateKey(), encrypted);
        Base64Data base64Data = new Base64Data();
        base64Data.setValue(decrypted);
        ((DocumentType)document.value).setBase64Data(base64Data);
    }
}

