/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.SoftKonServicePortType;
import de.gematik.bbriccs.konnektor.exceptions.SmartcardException;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.ws.conn.certificateservice.v6.CertificateExpirationType;
import de.gematik.ws.conn.certificateservice.v6.CryptType;
import de.gematik.ws.conn.certificateservice.v6.ReadCardCertificate;
import de.gematik.ws.conn.certificateservice.v6.VerifyCertificateResponse;
import de.gematik.ws.conn.certificateservice.wsdl.v6.CertificateServicePortType;
import de.gematik.ws.conn.certificateservice.wsdl.v6.FaultMessage;
import de.gematik.ws.conn.certificateservicecommon.v2.CertRefEnum;
import de.gematik.ws.conn.certificateservicecommon.v2.X509DataInfoListType;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.tel.error.v2.Error;
import jakarta.xml.ws.Holder;
import java.security.cert.CertificateEncodingException;
import java.text.MessageFormat;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.NotImplementedException;

public class SKCertificateServicePortType
extends SoftKonServicePortType
implements CertificateServicePortType {
    public SKCertificateServicePortType(SoftKonCore softKonCore) {
        super(softKonCore);
    }

    public void checkCertificateExpiration(String cardHandle, ContextType context, CryptType crypt, Holder<Status> status, Holder<List<CertificateExpirationType>> certificateExpiration) {
        throw new NotImplementedException("Check Certificate Expiration not implemented yet");
    }

    public void readCardCertificate(String cardHandle, ContextType context, ReadCardCertificate.CertRefList certRefList, CryptType crypt, Holder<Status> status, Holder<X509DataInfoListType> x509DataInfoList) throws FaultMessage {
        SmartcardP12 smartcard = this.softKonCore.getSmartcardByCardHandleSafely(SmartcardP12.class, cardHandle).orElseThrow(() -> new FaultMessage(MessageFormat.format("No card found with CardHandle {0}", cardHandle), this.softKonCore.createError(cardHandle)));
        status.value = new Status();
        x509DataInfoList.value = new X509DataInfoListType();
        this.setX509DataInfoListType(smartcard, certRefList, status, x509DataInfoList);
    }

    private void setX509DataInfoListType(SmartcardP12 smartcard, ReadCardCertificate.CertRefList certRefList, Holder<Status> status, Holder<X509DataInfoListType> x509DataInfoList) {
        X509DataInfoListType x509 = new X509DataInfoListType();
        String errorMessage = null;
        for (CertRefEnum cre : certRefList.getCertRef()) {
            X509DataInfoListType.X509DataInfo dataInfo = new X509DataInfoListType.X509DataInfo();
            if (cre == CertRefEnum.C_AUT) {
                dataInfo.setX509Data(this.getX509AuthData(smartcard));
                dataInfo.setCertRef(cre);
                x509.getX509DataInfo().add(dataInfo);
            } else {
                errorMessage = MessageFormat.format("{0} is not yet implemented", cre);
            }
            if (errorMessage == null) {
                ((Status)status.value).setResult("OK");
                x509DataInfoList.value = x509;
                continue;
            }
            Error error = this.softKonCore.createError(errorMessage);
            ((Status)status.value).setError(error);
        }
    }

    private X509DataInfoListType.X509DataInfo.X509Data getX509AuthData(SmartcardP12 smartcard) {
        X509DataInfoListType.X509DataInfo.X509Data data = new X509DataInfoListType.X509DataInfo.X509Data();
        try {
            data.setX509Certificate(smartcard.getAutCertificate().getX509Certificate().getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new SmartcardException(MessageFormat.format("Smartcard {0} does not have Auth Certificate", smartcard.getIccsn()), (Throwable)e);
        }
        return data;
    }

    public void verifyCertificate(ContextType context, byte[] x509Certificate, XMLGregorianCalendar verificationTime, Holder<Status> status, Holder<VerifyCertificateResponse.VerificationStatus> verificationStatus, Holder<VerifyCertificateResponse.RoleList> roleList) {
        throw new NotImplementedException("Verify Certificate not implemented yet");
    }
}

