/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.signature.EcdsaSigner;
import de.gematik.bbriccs.crypto.signature.RsaPssSigner;
import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.konnektor.SoftKonServicePortType;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import de.gematik.ws.conn.authsignatureservice.wsdl.v7_4.AuthSignatureServicePortType;
import de.gematik.ws.conn.authsignatureservice.wsdl.v7_4.FaultMessage;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import de.gematik.ws.conn.signatureservice.v7_4.BinaryDocumentType;
import de.gematik.ws.conn.signatureservice.v7_4.ExternalAuthenticate;
import jakarta.xml.ws.Holder;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.text.MessageFormat;
import oasis.names.tc.dss._1_0.core.schema.Base64Signature;
import oasis.names.tc.dss._1_0.core.schema.SignatureObject;

public class SKAuthSignatureServicePortType
extends SoftKonServicePortType
implements AuthSignatureServicePortType {
    public SKAuthSignatureServicePortType(SoftKonCore softKonCore) {
        super(softKonCore);
    }

    public void externalAuthenticate(String cardHandle, ContextType context, ExternalAuthenticate.OptionalInputs optionalInputs, BinaryDocumentType binaryString, Holder<Status> status, Holder<SignatureObject> signatureObject) throws FaultMessage {
        Smartcard smartcard = this.softKonCore.getSmartcardByCardHandleSafely(Smartcard.class, cardHandle).orElseThrow(() -> new FaultMessage(MessageFormat.format("No card found with CardHandle {0}", cardHandle), this.softKonCore.createError(cardHandle)));
        byte[] dataToBeSigned = binaryString.getBase64Data().getValue();
        CryptoSystem cryptoSystem = CryptoSystem.fromSpecificationUrn((String)optionalInputs.getSignatureType());
        SmartcardCertificate autCert = (SmartcardCertificate)smartcard.getAutCertificate(cryptoSystem).orElseThrow(() -> new SmartCardKeyNotFoundException(smartcard, smartcard.getAutOids(), cryptoSystem));
        RsaPssSigner signatureMethod = autCert.getPrivateKey() instanceof RSAPrivateKey ? RsaPssSigner.sha256withMgf1() : new EcdsaSigner();
        byte[] signedData = signatureMethod.sign((Key)autCert.getPrivateKey(), dataToBeSigned);
        Base64Signature base64Signature = new Base64Signature();
        base64Signature.setValue(signedData);
        signatureObject.value = new SignatureObject();
        ((SignatureObject)signatureObject.value).setBase64Signature(base64Signature);
        status.value = new Status();
        ((Status)status.value).setResult("OK");
    }
}

