/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.SoftKonSigner;
import de.gematik.bbriccs.konnektor.exceptions.SmartcardException;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmcB;
import eu.europa.esig.dss.model.DSSException;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class SoftKonSignerTest {
    private static final SmartcardArchive sca = SmartcardArchive.fromResources();

    SoftKonSignerTest() {
    }

    static Stream<Arguments> shouldSignDocumentWithSmartcard() {
        return Stream.of(sca.getHba(0), sca.getSmcB(0)).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldSignDocumentWithSmartcard(SmartcardP12 smartcard) {
        SoftKonSigner signer = new SoftKonSigner();
        byte[] data = "HelloWorld".getBytes();
        byte[] signed = (byte[])Assertions.assertDoesNotThrow(() -> signer.signDocument((Smartcard)smartcard, CryptoSystem.RSA_2048, false, data));
        Assertions.assertNotNull((Object)signed);
        Assertions.assertTrue((signed.length > 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @MethodSource(value={"shouldSignDocumentWithSmartcard"})
    void shouldThrowOnByteArrayOperation(SmartcardP12 smartcard) {
        SoftKonSigner signer = new SoftKonSigner();
        byte[] data = "HelloWorld".getBytes();
        try (MockedStatic mio = Mockito.mockStatic(IOUtils.class);){
            mio.when(() -> IOUtils.toByteArray((InputStream)((InputStream)ArgumentMatchers.any(InputStream.class)))).thenThrow(new Throwable[]{new IOException()});
            Assertions.assertThrows(DSSException.class, () -> signer.signDocument((Smartcard)smartcard, CryptoSystem.RSA_2048, false, data));
        }
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class, mode=EnumSource.Mode.EXCLUDE, names={"RSA_PSS_2048"})
    void shouldSignDocumentWithHba(CryptoSystem cryptoSystem) {
        Hba smartcard = sca.getHba(0);
        SoftKonSigner signer = new SoftKonSigner();
        byte[] signed = (byte[])Assertions.assertDoesNotThrow(() -> signer.signDocument(smartcard, cryptoSystem, false, "HelloWorld"));
        Assertions.assertNotNull((Object)signed);
        Assertions.assertTrue((signed.length > 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @EnumSource(value=CryptoSystem.class, mode=EnumSource.Mode.EXCLUDE, names={"RSA_PSS_2048"})
    void shouldSignDocumentWithSmcb(CryptoSystem cryptoSystem) {
        SmcB smartcard = sca.getSmcB(0);
        SoftKonSigner signer = new SoftKonSigner();
        byte[] signed = (byte[])Assertions.assertDoesNotThrow(() -> signer.signDocument(smartcard, cryptoSystem, false, "HelloWorld"));
        Assertions.assertNotNull((Object)signed);
        Assertions.assertTrue((signed.length > 0 ? 1 : 0) != 0);
    }

    @Test
    void shouldThrowOnSigningWithInvalidSmartcard() {
        SoftKonSigner signer = new SoftKonSigner();
        Egk smartcard = sca.getEgk(0);
        byte[] data = "HelloWorld".getBytes();
        Assertions.assertThrows(SmartcardException.class, () -> signer.signDocument((Smartcard)smartcard, CryptoSystem.RSA_2048, false, data));
    }
}

