/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.konnektor.SoftKonCore;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.HbaP12;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmcBP12;
import de.gematik.bbriccs.smartcards.exceptions.CardNotFoundException;
import de.gematik.ws.conn.cardservice.v8.CardInfoType;
import de.gematik.ws.conn.cardservice.v8.Cards;
import de.gematik.ws.conn.cardservicecommon.v2.CardTypeType;
import de.gematik.ws.conn.signatureservice.wsdl.v7.FaultMessage;
import java.util.Optional;
import javax.xml.datatype.DatatypeFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class SoftKonCoreTest {
    SoftKonCoreTest() {
    }

    @Test
    void shouldGetCards() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Cards cards = (Cards)Assertions.assertDoesNotThrow(() -> ((SoftKonCore)skc).getAllCards());
        Assertions.assertNotNull((Object)cards);
    }

    @Test
    void shouldGetSmartcardByHandle() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Cards cards = (Cards)Assertions.assertDoesNotThrow(() -> ((SoftKonCore)skc).getAllCards());
        CardInfoType egkInfoType = cards.getCard().stream().filter(cit -> cit.getCardType().equals((Object)CardTypeType.HBA)).findFirst().orElseThrow();
        Optional smartcard = (Optional)Assertions.assertDoesNotThrow(() -> skc.getSmartcardByCardHandleSafely(HbaP12.class, egkInfoType.getCardHandle()));
        Assertions.assertTrue((boolean)smartcard.isPresent());
    }

    @ParameterizedTest
    @ValueSource(classes={EgkP12.class, HbaP12.class, SmcBP12.class})
    void shouldThrowOnUnknownHandle(Class<SmartcardP12> smartcardClass) {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Assertions.assertThrows(CardNotFoundException.class, () -> skc.getSmartcardByCardHandle(smartcardClass, "unknown"));
    }

    @Test
    void shouldThrowOnSignWithUnknownCardHandle() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Assertions.assertThrows(FaultMessage.class, () -> skc.signDocumentWith("unkown", CryptoSystem.RSA_2048, false, "HelloWorld".getBytes()));
    }

    @Test
    void shouldThrowOnSignWithEgk() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Cards cards = (Cards)Assertions.assertDoesNotThrow(() -> ((SoftKonCore)skc).getAllCards());
        CardInfoType egkInfoType = cards.getCard().stream().filter(cit -> cit.getCardType().equals((Object)CardTypeType.EGK)).findFirst().orElseThrow();
        Assertions.assertThrows(FaultMessage.class, () -> skc.signDocumentWith(egkInfoType.getCardHandle(), CryptoSystem.RSA_2048, false, "HelloWorld".getBytes()));
    }

    @Test
    void shouldSignAndVerify() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        Cards cards = (Cards)Assertions.assertDoesNotThrow(() -> ((SoftKonCore)skc).getAllCards());
        CardInfoType hbaCardInfo = cards.getCard().stream().filter(cit -> cit.getCardType().equals((Object)CardTypeType.HBA)).findFirst().orElseThrow();
        byte[] signed = (byte[])Assertions.assertDoesNotThrow(() -> skc.signDocumentWith(hbaCardInfo.getCardHandle(), CryptoSystem.RSA_2048, false, "HelloWorld".getBytes()));
        Assertions.assertTrue((boolean)skc.verifyDocument(signed));
    }

    @Test
    void shouldIncrementJobNumber() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        String j1 = skc.getJobNumber(null);
        String j2 = skc.getJobNumber(null);
        Assertions.assertFalse((boolean)j1.isEmpty());
        Assertions.assertFalse((boolean)j2.isEmpty());
        Assertions.assertNotEquals((Object)j1, (Object)j2);
    }

    @Test
    void shouldReThrowDatatypeError() {
        SoftKonCore skc = new SoftKonCore(SmartcardArchive.fromResources());
        try (MockedStatic msdtf = Mockito.mockStatic(DatatypeFactory.class);){
            msdtf.when(DatatypeFactory::newInstance).thenThrow(new Throwable[]{new RuntimeException("Test")});
            Assertions.assertThrows(RuntimeException.class, () -> skc.createError("test"));
        }
    }
}

