/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.ParsingUpdateReasonException;
import de.gematik.bbriccs.konnektor.vsdm.VsdmUpdateReason;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class VsdmUpdateReasonTest {
    VsdmUpdateReasonTest() {
    }

    @Test
    void shouldThrowOnInvalidChecksum() {
        Assertions.assertThrows(ParsingUpdateReasonException.class, () -> VsdmUpdateReason.fromChecksum((char)'X'));
    }

    @ParameterizedTest
    @EnumSource(value=VsdmUpdateReason.class)
    void shouldMapFromChecksum(VsdmUpdateReason reason) {
        Assertions.assertEquals((Object)reason, (Object)VsdmUpdateReason.fromChecksum((char)reason.getIdentifier()));
    }

    @ParameterizedTest
    @EnumSource(value=VsdmUpdateReason.class)
    void shouldContainDescriptionInToString(VsdmUpdateReason reason) {
        Assertions.assertTrue((boolean)reason.toString().contains(reason.getDescription()));
    }
}

