/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.cfg.VsdmServiceConfiguration;
import de.gematik.bbriccs.konnektor.vsdm.VsdmChecksum;
import de.gematik.bbriccs.konnektor.vsdm.VsdmService;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class VsdmServiceTest {
    VsdmServiceTest() {
    }

    static Stream<Arguments> shouldSignWithChecksums() {
        return Stream.of(Arguments.of((Object[])new Object[]{VsdmService::checksumFor}), Arguments.of((Object[])new Object[]{VsdmService::checksumWithInvalidManufacturer}), Arguments.of((Object[])new Object[]{VsdmService::checksumWithInvalidVersion}));
    }

    @Test
    void shouldCreateFromConfig() {
        VsdmServiceConfiguration cfg = VsdmServiceConfiguration.createDefault();
        Assertions.assertDoesNotThrow(() -> VsdmService.createFrom((VsdmServiceConfiguration)cfg));
    }

    @ParameterizedTest
    @MethodSource
    void shouldSignWithChecksums(BiFunction<VsdmService, String, VsdmChecksum> biFunction) {
        VsdmServiceConfiguration cfg = VsdmServiceConfiguration.createDefault();
        VsdmService vsdm = (VsdmService)Assertions.assertDoesNotThrow(() -> VsdmService.createFrom((VsdmServiceConfiguration)cfg));
        VsdmChecksum checksum = (VsdmChecksum)Assertions.assertDoesNotThrow(() -> (VsdmChecksum)biFunction.apply(vsdm, "X117170400"));
        Assertions.assertDoesNotThrow(() -> vsdm.sign(checksum));
    }
}

