/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor.vsdm;

import de.gematik.bbriccs.konnektor.exceptions.ParsingExamEvidenceException;
import de.gematik.bbriccs.konnektor.vsdm.VsdmExamEvidence;
import de.gematik.bbriccs.konnektor.vsdm.VsdmExamEvidenceResult;
import de.gematik.bbriccs.konnektor.vsdm.VsdmUpdateReason;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import java.io.IOException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;

class VsdmExamEvidenceTest {
    VsdmExamEvidenceTest() {
    }

    static Stream<Arguments> builderFunctionProvider() {
        return Stream.of(Arguments.of((Object[])new Object[]{builder -> builder.withExpiredTimestamp().checksumWithUpdateReason(VsdmUpdateReason.CARD_MANAGEMENT_UPDATE).generate(VsdmExamEvidenceResult.NO_UPDATES)}), Arguments.of((Object[])new Object[]{builder -> builder.withInvalidTimestamp().checksumWithUpdateReason(VsdmUpdateReason.UFS_UPDATE).checksumWithInvalidManufacturer().checksumWithInvalidKvnr().checksumWithInvalidVersion().generate(VsdmExamEvidenceResult.NO_UPDATES)}));
    }

    @ParameterizedTest
    @MethodSource(value={"builderFunctionProvider"})
    void shouldBuildAsOfflineMode(Function<VsdmExamEvidence.VsdmExamEvidenceBuilder, VsdmExamEvidence> builderFunction) {
        VsdmExamEvidence.VsdmExamEvidenceBuilder evidenceBuilder = VsdmExamEvidence.asOfflineMode();
        VsdmExamEvidence evidence = builderFunction.apply(evidenceBuilder);
        Assertions.assertFalse((boolean)evidence.getChecksum().isPresent());
        Assertions.assertNotNull((Object)evidence.encodeAsBase64());
        Assertions.assertFalse((boolean)evidence.encodeAsBase64().isEmpty());
        Assertions.assertNotNull((Object)evidence.getCdmVersion());
        Assertions.assertFalse((boolean)evidence.getCdmVersion().isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"builderFunctionProvider"})
    void shouldBuildAsOnlineTestMode(Function<VsdmExamEvidence.VsdmExamEvidenceBuilder, VsdmExamEvidence> builderFunction) {
        SmartcardArchive sca = SmartcardArchive.fromResources();
        VsdmExamEvidence.VsdmExamEvidenceBuilder evidenceBuilder = VsdmExamEvidence.asOnlineTestMode((Egk)sca.getEgk(0));
        VsdmExamEvidence evidence = builderFunction.apply(evidenceBuilder);
        Assertions.assertTrue((boolean)evidence.getChecksum().isPresent());
        Assertions.assertNotNull((Object)evidence.encodeAsBase64());
        Assertions.assertFalse((boolean)evidence.encodeAsBase64().isEmpty());
        Assertions.assertNotNull((Object)evidence.getCdmVersion());
        Assertions.assertFalse((boolean)evidence.getCdmVersion().isEmpty());
        Assertions.assertDoesNotThrow(() -> ((VsdmExamEvidence)evidence).toString());
    }

    @Test
    void shouldParseFromBase64() {
        String b64 = "H4sIAAAAAAAA/x2NQU/DIABG/0rD3UIpM5sBlimoMyl1Fjn0YjqLW+dKp9S226+X7PIdXvK9R5dTe4wG++ubzjGQxAhE1n12deN2DLzrx5s5iHxfubo6ds4ycLYeLDl9VVE4Os/Avu9PdxCOPt7Ztuqb77i28KuCg69beHIjHK7SB5F9GPlWrHN1zQTGqS44RpigNFlgRBbJjMKAqOSYQhkiJTdihdRBouywmeVapplekVzIi9LGGPFM1rBMVSOwKObj9q91T5dyP93m0wv52d5vPKMwSMIo/g9W9xM96gAAAA==";
        String checksum = "VDA0NjE0MjQ5OTE3MTA4ODEzNTVVVDH4I/Z3NiD2DS8wbumnGzZhx6OxJ4qbBQs=";
        VsdmExamEvidence evidence = (VsdmExamEvidence)Assertions.assertDoesNotThrow(() -> VsdmExamEvidence.parse((String)"H4sIAAAAAAAA/x2NQU/DIABG/0rD3UIpM5sBlimoMyl1Fjn0YjqLW+dKp9S226+X7PIdXvK9R5dTe4wG++ubzjGQxAhE1n12deN2DLzrx5s5iHxfubo6ds4ycLYeLDl9VVE4Os/Avu9PdxCOPt7Ztuqb77i28KuCg69beHIjHK7SB5F9GPlWrHN1zQTGqS44RpigNFlgRBbJjMKAqOSYQhkiJTdihdRBouywmeVapplekVzIi9LGGPFM1rBMVSOwKObj9q91T5dyP93m0wv52d5vPKMwSMIo/g9W9xM96gAAAA=="));
        Assertions.assertTrue((boolean)evidence.getChecksum().isPresent());
        Assertions.assertEquals((Object)"VDA0NjE0MjQ5OTE3MTA4ODEzNTVVVDH4I/Z3NiD2DS8wbumnGzZhx6OxJ4qbBQs=", evidence.getChecksum().orElseThrow());
    }

    @Test
    void shouldThrowOnInvalidExamEvidence() {
        Assertions.assertThrows(ParsingExamEvidenceException.class, () -> VsdmExamEvidence.parse((String)"invalid"));
    }

    @Test
    void shouldReThrowOnCompress() {
        VsdmExamEvidence evidence = VsdmExamEvidence.asOfflineMode().generate(VsdmExamEvidenceResult.NO_UPDATES);
        try (MockedConstruction mc = Mockito.mockConstruction(GZIPOutputStream.class, (mock, context) -> ((GZIPOutputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("TEST")}).when(mock)).write((byte[])ArgumentMatchers.any()));){
            IOException ioe = (IOException)Assertions.assertThrows(IOException.class, () -> ((VsdmExamEvidence)evidence).encode());
            Assertions.assertTrue((boolean)ioe.getMessage().contains("TEST"));
        }
    }
}

