/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.konnektor.SofKonServicePort;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.ws.conn.cardservice.wsdl.v8.CardServicePortType;
import de.gematik.ws.conn.cardservicecommon.v2.PinResultEnum;
import de.gematik.ws.conn.connectorcommon.v5.Status;
import de.gematik.ws.conn.connectorcontext.v2.ContextType;
import jakarta.xml.ws.Holder;
import org.apache.commons.lang3.NotImplementedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class SKCardServicePortTypeTest {
    private static ContextType ctx;
    private static SofKonServicePort softKonServiceProvider;

    SKCardServicePortTypeTest() {
    }

    @BeforeAll
    static void setup() {
        SmartcardArchive smartCardArchive = SmartcardArchive.fromResources();
        softKonServiceProvider = new SofKonServicePort(smartCardArchive);
        ctx = new ContextType();
        ctx.setClientSystemId("cs1");
        ctx.setMandantId("m1");
        ctx.setUserId("u1");
        ctx.setWorkplaceId("w1");
    }

    @Test
    void shouldThrowExceptions() {
        CardServicePortType cardService = softKonServiceProvider.getCardService();
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.changePin(ctx, null, null, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.disablePin(ctx, null, null, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.enablePin(ctx, null, null, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.changePin(ctx, null, null, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.getPinStatus(ctx, null, null, null, null, null));
        Assertions.assertThrows(NotImplementedException.class, () -> cardService.unblockPin(ctx, null, null, null, null, null, null));
    }

    @Test
    void shouldAlwaysVerifyPin() {
        CardServicePortType cardService = softKonServiceProvider.getCardService();
        Holder status = new Holder();
        Holder pinResult = new Holder();
        Holder leftTries = new Holder();
        Assertions.assertDoesNotThrow(() -> cardService.verifyPin(ctx, null, null, status, pinResult, leftTries));
        Assertions.assertEquals((Object)"OK", (Object)((Status)status.value).getResult());
        Assertions.assertEquals((Object)PinResultEnum.OK, (Object)pinResult.value);
    }
}

