/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.LdapReader;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardExtension;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartcardP12
implements Smartcard {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartcardP12.class);
    private final SmartcardConfigDto config;
    private final List<SmartcardCertificate> certificates;
    private final String iccsn;
    private final SmartcardType type;
    private final SmartcardOwnerData ownerData;

    protected SmartcardP12(SmartcardType type, SmartcardConfigDto config, List<SmartcardCertificate> certificates) {
        if (!config.getType().equals((Object)type)) {
            throw new InvalidSmartcardTypeException(type, config.getType());
        }
        this.config = config;
        this.certificates = certificates;
        this.iccsn = this.config.getIccsn();
        this.type = type;
        this.ownerData = LdapReader.getOwnerData(this.getAutCertificate().getX509Certificate().getSubjectX500Principal());
        log.trace(MessageFormat.format("Initialize smartcard {0} with iccsn={1}", this.type.name(), this.iccsn));
    }

    public SmartcardCertificate getAutCertificate() {
        return this.getAutCertificate(CryptoSystem.ECC_256).or(() -> this.getAutCertificate(CryptoSystem.RSA_2048)).or(() -> this.getAutCertificate(CryptoSystem.RSA_PSS_2048)).orElseThrow(() -> new SmartCardKeyNotFoundException((Smartcard)this));
    }

    public Optional<SmartcardCertificate> getAutCertificate(CryptoSystem cryptoSystem) {
        List oids = this.getAutOids();
        return oids.stream().map(it -> this.getKey((Oid)it, cryptoSystem)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public PrivateKey getAuthPrivateKey() {
        return this.getAutCertificate().getPrivateKey();
    }

    public PublicKey getAuthPublicKey() {
        return this.getAutCertificate().getX509Certificate().getPublicKey();
    }

    public String getPrivateKeyBase64() {
        String string;
        PrivateKey pk = this.getAuthPrivateKey();
        try (ASN1InputStream input = new ASN1InputStream(pk.getEncoded());){
            ASN1Primitive asn1Object = input.readObject();
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)asn1Object);
            ASN1OctetString encapsulated = ASN1OctetString.getInstance((Object)asn1Sequence.getObjectAt(2));
            ASN1Sequence encapsulatedAsn1Sequence = ASN1Sequence.getInstance((Object)encapsulated.getOctets());
            ASN1OctetString encapsulatedPrivateKey = ASN1OctetString.getInstance((Object)encapsulatedAsn1Sequence.getObjectAt(1));
            string = Base64.toBase64String((byte[])encapsulatedPrivateKey.getOctets());
        }
        return string;
    }

    protected Optional<SmartcardCertificate> getKey(Oid oid, CryptoSystem cryptoSystem) {
        log.debug(MessageFormat.format("Look for smartcard certificate with oid={0} and algorithm={1}", oid, cryptoSystem));
        return this.certificates.stream().filter(it -> it.getCryptoSystem() == cryptoSystem).filter(it -> it.getOid() == oid).findFirst();
    }

    public Map<String, Object> getExtension() {
        return this.config.getSmartcardExtension();
    }

    public <E extends SmartcardExtension> E getExtensionAs(Class<E> extensionType) {
        return (E)((SmartcardExtension)new ObjectMapper().convertValue(this.getExtension(), extensionType));
    }

    public String toString() {
        return MessageFormat.format("Smartcard {0} [iccsn={1}]", this.type, this.iccsn);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartcardP12)) {
            return false;
        }
        SmartcardP12 other = (SmartcardP12)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SmartcardConfigDto this$config = this.config;
        SmartcardConfigDto other$config = other.config;
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        List<SmartcardCertificate> this$certificates = this.certificates;
        List<SmartcardCertificate> other$certificates = other.certificates;
        if (this$certificates == null ? other$certificates != null : !((Object)this$certificates).equals(other$certificates)) {
            return false;
        }
        String this$iccsn = this.getIccsn();
        String other$iccsn = other.getIccsn();
        if (this$iccsn == null ? other$iccsn != null : !this$iccsn.equals(other$iccsn)) {
            return false;
        }
        SmartcardType this$type = this.getType();
        SmartcardType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        SmartcardOwnerData this$ownerData = this.getOwnerData();
        SmartcardOwnerData other$ownerData = other.getOwnerData();
        return !(this$ownerData == null ? other$ownerData != null : !this$ownerData.equals(other$ownerData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SmartcardP12;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SmartcardConfigDto $config = this.config;
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        List<SmartcardCertificate> $certificates = this.certificates;
        result = result * 59 + ($certificates == null ? 43 : ((Object)$certificates).hashCode());
        String $iccsn = this.getIccsn();
        result = result * 59 + ($iccsn == null ? 43 : $iccsn.hashCode());
        SmartcardType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        SmartcardOwnerData $ownerData = this.getOwnerData();
        result = result * 59 + ($ownerData == null ? 43 : $ownerData.hashCode());
        return result;
    }

    @Generated
    public String getIccsn() {
        return this.iccsn;
    }

    @Generated
    public SmartcardType getType() {
        return this.type;
    }

    @Generated
    public SmartcardOwnerData getOwnerData() {
        return this.ownerData;
    }
}

